/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sparse.GradientValue_F32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseTwo1_F32
implements SparseImageGradient<GrayF32, GradientValue_F32> {
    GrayF32 input;
    ImageBorder_F32 border;
    GradientValue_F32 gradient = new GradientValue_F32();

    public GradientSparseTwo1_F32(ImageBorder_F32 border) {
        this.border = border;
    }

    public GradientValue_F32 compute(int x, int y) {
        float a10;
        float a01;
        float a11;
        if (x > 0 && y > 0 && x < this.input.width && y < this.input.height) {
            int s = this.input.stride;
            int br = this.input.startIndex + s * y + x;
            a11 = this.input.data[br];
            a01 = this.input.data[br - s];
            a10 = this.input.data[br - 1];
        } else {
            a11 = this.border.get(x, y);
            a01 = this.border.get(x, y - 1);
            a10 = this.border.get(x - 1, y);
        }
        this.gradient.y = a11 - a01;
        this.gradient.x = a11 - a10;
        return this.gradient;
    }

    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }

    public void setImage(GrayF32 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage((ImageBase)input);
        }
    }

    public boolean isInBounds(int x, int y) {
        return this.border != null || x > 0 && y > 0 && x < this.input.width && y < this.input.height;
    }
}

