/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.impl.ImplImageStatistics;
import boofcv.alg.misc.impl.ImplImageStatistics_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;

public class ImageStatistics {
    public static int min(GrayU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.minU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.minU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int max(GrayU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int maxAbs(GrayU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedU8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayU8 imgA, GrayU8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedU8 imgA, InterleavedU8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayU8 imgA, GrayU8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedU8 imgA, InterleavedU8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static int sum(GrayU8 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayU8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedU8 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedU8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayU8 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayU8 input, int minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static int min(GrayS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int max(GrayS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int maxAbs(GrayS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS8 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayS8 imgA, GrayS8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS8 imgA, InterleavedS8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayS8 imgA, GrayS8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS8 imgA, InterleavedS8 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static int sum(GrayS8 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayS8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS8 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedS8 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS8 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayS8 input, int minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static int min(GrayU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.minU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.minU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.minU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int max(GrayU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int maxAbs(GrayU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedU16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbsU(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayU16 imgA, GrayU16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedU16 imgA, InterleavedU16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSqU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayU16 imgA, GrayU16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedU16 imgA, InterleavedU16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbsU(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static int sum(GrayU16 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayU16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedU16 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedU16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayU16 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayU16 input, int minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static int min(GrayS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int max(GrayS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int maxAbs(GrayS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS16 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayS16 imgA, GrayS16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS16 imgA, InterleavedS16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayS16 imgA, GrayS16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS16 imgA, InterleavedS16 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static int sum(GrayS16 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayS16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS16 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedS16 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS16 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayS16 input, int minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static int min(GrayS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int min(InterleavedS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int max(GrayS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int max(InterleavedS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static int maxAbs(GrayS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static int maxAbs(InterleavedS32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayS32 imgA, GrayS32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS32 imgA, InterleavedS32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayS32 imgA, GrayS32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS32 imgA, InterleavedS32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static int sum(GrayS32 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayS32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static int sum(InterleavedS32 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedS32 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS32 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayS32 input, int minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static long min(GrayS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long min(InterleavedS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static long max(GrayS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long max(InterleavedS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static long maxAbs(GrayS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static long maxAbs(InterleavedS64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayS64 imgA, GrayS64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedS64 imgA, InterleavedS64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayS64 imgA, GrayS64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedS64 imgA, InterleavedS64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static long sum(GrayS64 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayS64 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static long sum(InterleavedS64 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedS64 img) {
        return (double)ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayS64 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayS64 input, long minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static float min(GrayF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float min(InterleavedF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static float max(GrayF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float max(InterleavedF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static float maxAbs(GrayF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static float maxAbs(InterleavedF32 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayF32 imgA, GrayF32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedF32 imgA, InterleavedF32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayF32 imgA, GrayF32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedF32 imgA, InterleavedF32 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static float sum(GrayF32 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static float mean(GrayF32 img) {
        return ImageStatistics.sum(img) / (float)(img.width * img.height);
    }

    public static float sum(InterleavedF32 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static float mean(InterleavedF32 img) {
        return ImageStatistics.sum(img) / (float)(img.width * img.height * img.numBands);
    }

    public static float variance(GrayF32 img, float mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayF32 input, float minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }

    public static double min(GrayF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double min(InterleavedF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.min(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double max(GrayF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double max(InterleavedF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.max(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double maxAbs(GrayF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width, input.stride);
    }

    public static double maxAbs(InterleavedF64 input) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
        }
        return ImplImageStatistics.maxAbs(input.data, input.startIndex, input.height, input.width * input.numBands, input.stride);
    }

    public static double meanDiffSq(GrayF64 imgA, GrayF64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffSq(InterleavedF64 imgA, InterleavedF64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffSq(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double meanDiffAbs(GrayF64 imgA, GrayF64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width);
    }

    public static double meanDiffAbs(InterleavedF64 imgA, InterleavedF64 imgB) {
        InputSanityCheck.checkSameShape((ImageBase)imgA, (ImageBase)imgB);
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
        }
        return ImplImageStatistics.meanDiffAbs(imgA.data, imgA.startIndex, imgA.stride, imgB.data, imgB.startIndex, imgB.stride, imgA.height, imgA.width * imgA.numBands);
    }

    public static double sum(GrayF64 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(GrayF64 img) {
        return ImageStatistics.sum(img) / (double)(img.width * img.height);
    }

    public static double sum(InterleavedF64 img) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.sum(img);
        }
        return ImplImageStatistics.sum(img);
    }

    public static double mean(InterleavedF64 img) {
        return ImageStatistics.sum(img) / (double)(img.width * img.height * img.numBands);
    }

    public static double variance(GrayF64 img, double mean) {
        if (BoofConcurrency.USE_CONCURRENT) {
            return ImplImageStatistics_MT.variance(img, mean);
        }
        return ImplImageStatistics.variance(img, mean);
    }

    public static void histogram(GrayF64 input, double minValue, int[] histogram) {
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageStatistics_MT.histogram(input, minValue, histogram);
        } else {
            ImplImageStatistics.histogram(input, minValue, histogram);
        }
    }
}

