/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigThreshold
implements Configuration {
    public ThresholdType type;
    public double fixedThreshold;
    public double scale = 0.95;
    public boolean down = true;
    public ConfigLength width = ConfigLength.fixed((double)11.0);
    public float savolaK = 0.3f;
    public float nickK = -0.2f;
    public int minPixelValue = 0;
    public int maxPixelValue = 255;
    public boolean thresholdFromLocalBlocks = true;

    public static ConfigThreshold fixed(double value) {
        ConfigThreshold config = new ConfigThreshold();
        config.type = ThresholdType.FIXED;
        config.fixedThreshold = value;
        return config;
    }

    public static ConfigThreshold global(ThresholdType type) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (!type.isGlobal()) {
            throw new IllegalArgumentException("Type must be global");
        }
        ConfigThreshold config = new ConfigThreshold();
        config.type = type;
        return config;
    }

    public static <T extends ConfigThreshold> T local(ThresholdType type, int width) {
        return ConfigThreshold.local(type, ConfigLength.fixed((double)width));
    }

    public static <T extends ConfigThreshold> T local(ThresholdType type, ConfigLength width) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (type.isGlobal()) {
            throw new IllegalArgumentException("Type must be local");
        }
        ConfigThreshold config = type == ThresholdType.BLOCK_MIN_MAX ? new ConfigThresholdBlockMinMax(width, 10.0, true) : (type == ThresholdType.BLOCK_OTSU ? new ConfigThresholdLocalOtsu() : new ConfigThreshold());
        config.type = type;
        config.width = width;
        return (T)config;
    }

    public void checkValidity() {
    }

    public String toString() {
        return "ConfigThreshold{type=" + (Object)((Object)this.type) + ", fixedThreshold=" + this.fixedThreshold + ", scale=" + this.scale + ", down=" + this.down + ", width=" + this.width + ", savolaK=" + this.savolaK + ", minPixelValue=" + this.minPixelValue + ", maxPixelValue=" + this.maxPixelValue + '}';
    }
}

