/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.abst.filter.binary.GlobalEntropyBinaryFilter;
import boofcv.abst.filter.binary.GlobalFixedBinaryFilter;
import boofcv.abst.filter.binary.GlobalHuangBinaryFilter;
import boofcv.abst.filter.binary.GlobalLiBinaryFilter;
import boofcv.abst.filter.binary.GlobalOtsuBinaryFilter;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.binary.InputToBinarySwitch;
import boofcv.abst.filter.binary.LocalGaussianBinaryFilter;
import boofcv.abst.filter.binary.LocalMeanBinaryFilter;
import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.alg.filter.binary.ThresholdBlockMinMax;
import boofcv.alg.filter.binary.ThresholdBlockOtsu;
import boofcv.alg.filter.binary.ThresholdBlock_MT;
import boofcv.alg.filter.binary.ThresholdLocalOtsu;
import boofcv.alg.filter.binary.ThresholdLocalOtsu_MT;
import boofcv.alg.filter.binary.ThresholdNick;
import boofcv.alg.filter.binary.ThresholdSauvola;
import boofcv.alg.filter.binary.ThresholdSauvola_MT;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_U8;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_U8;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.filter.binary.BOverrideFactoryThresholdBinary;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU8;

public class FactoryThresholdBinary {
    public static <T extends ImageGray<T>> InputToBinary<T> localGaussian(ConfigLength regionWidth, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localGaussian != null) {
            return BOverrideFactoryThresholdBinary.localGaussian.handle(regionWidth, scale, down, inputType);
        }
        return new LocalGaussianBinaryFilter(regionWidth, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localSauvola(ConfigLength width, boolean down, float k, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localSauvola != null) {
            return BOverrideFactoryThresholdBinary.localSauvola.handle(width, k, down, inputType);
        }
        InputToBinary<GrayF32> sauvola = BoofConcurrency.USE_CONCURRENT ? new ThresholdSauvola_MT(width, k, down) : new ThresholdSauvola(width, k, down);
        return new InputToBinarySwitch<T>(sauvola, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localNick(ConfigLength width, boolean down, float k, Class<T> inputType) {
        return new InputToBinarySwitch<T>(new ThresholdNick(width, k, down), inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localMean(ConfigLength width, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localMean != null) {
            return BOverrideFactoryThresholdBinary.localMean.handle(width, scale, down, inputType);
        }
        return new LocalMeanBinaryFilter(width, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localOtsu(ConfigLength regionWidth, double scale, boolean down, boolean otsu2, double tuning, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localOtsu != null) {
            return BOverrideFactoryThresholdBinary.localOtsu.handle(otsu2, regionWidth, tuning, scale, down, inputType);
        }
        ThresholdLocalOtsu otsu = BoofConcurrency.USE_CONCURRENT ? new ThresholdLocalOtsu_MT(otsu2, regionWidth, tuning, scale, down) : new ThresholdLocalOtsu(otsu2, regionWidth, tuning, scale, down);
        return new InputToBinarySwitch<T>(otsu, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMinMax(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, double minimumSpread, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMinMax != null) {
            return BOverrideFactoryThresholdBinary.blockMinMax.handle(regionWidth, scale, down, minimumSpread, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockMinMax processor = inputType == GrayU8.class ? new ThresholdBlockMinMax_U8(minimumSpread, scale, down) : new ThresholdBlockMinMax_F32((float)minimumSpread, (float)scale, down);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new ThresholdBlock_MT<GrayU8, InterleavedU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
        }
        return new ThresholdBlock<GrayU8, InterleavedU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMean(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMean != null) {
            return BOverrideFactoryThresholdBinary.blockMean.handle(regionWidth, scale, down, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockMean processor = inputType == GrayU8.class ? new ThresholdBlockMean_U8(scale, down) : new ThresholdBlockMean_F32((float)scale, down);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new ThresholdBlock_MT<GrayU8, GrayU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
        }
        return new ThresholdBlock<GrayU8, GrayU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockOtsu(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, boolean otsu2, double tuning, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockOtsu != null) {
            return BOverrideFactoryThresholdBinary.blockOtsu.handle(otsu2, regionWidth, tuning, scale, down, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockOtsu processor = new ThresholdBlockOtsu(otsu2, tuning, scale, down);
        ThresholdBlock otsu = BoofConcurrency.USE_CONCURRENT ? new ThresholdBlock_MT<GrayU8, InterleavedS32>(processor, regionWidth, thresholdFromLocalBlocks, GrayU8.class) : new ThresholdBlock<GrayU8, InterleavedS32>(processor, regionWidth, thresholdFromLocalBlocks, GrayU8.class);
        return new InputToBinarySwitch<T>(otsu, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalEntropy(int minValue, int maxValue, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalEntropy != null) {
            return BOverrideFactoryThresholdBinary.globalEntropy.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalEntropyBinaryFilter(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalFixed(double threshold, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalFixed != null) {
            return BOverrideFactoryThresholdBinary.globalFixed.handle(threshold, down, inputType);
        }
        return new GlobalFixedBinaryFilter(threshold, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalOtsu(double minValue, double maxValue, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalOtsu != null) {
            return BOverrideFactoryThresholdBinary.globalOtsu.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalOtsuBinaryFilter(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalLi(double minValue, double maxValue, boolean down, Class<T> inputType) {
        return new GlobalLiBinaryFilter(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalHuang(double minValue, double maxValue, boolean down, Class<T> inputType) {
        return new GlobalHuangBinaryFilter(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> threshold(ConfigThreshold config, Class<T> inputType) {
        switch (config.type) {
            case FIXED: {
                return FactoryThresholdBinary.globalFixed(config.fixedThreshold, config.down, inputType);
            }
            case GLOBAL_OTSU: {
                return FactoryThresholdBinary.globalOtsu(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case GLOBAL_ENTROPY: {
                return FactoryThresholdBinary.globalEntropy(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case GLOBAL_LI: {
                return FactoryThresholdBinary.globalLi(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case GLOBAL_HUANG: {
                return FactoryThresholdBinary.globalHuang(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case LOCAL_GAUSSIAN: {
                return FactoryThresholdBinary.localGaussian(config.width, config.scale, config.down, inputType);
            }
            case LOCAL_SAVOLA: {
                return FactoryThresholdBinary.localSauvola(config.width, config.down, config.savolaK, inputType);
            }
            case LOCAL_NICK: {
                return FactoryThresholdBinary.localNick(config.width, config.down, config.nickK, inputType);
            }
            case LOCAL_MEAN: {
                return FactoryThresholdBinary.localMean(config.width, config.scale, config.down, inputType);
            }
            case LOCAL_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                return FactoryThresholdBinary.localOtsu(config.width, config.scale, config.down, c.useOtsu2, c.tuning, inputType);
            }
            case BLOCK_MIN_MAX: {
                ConfigThresholdBlockMinMax c = (ConfigThresholdBlockMinMax)config;
                return FactoryThresholdBinary.blockMinMax(c.width, c.scale, c.down, c.thresholdFromLocalBlocks, c.minimumSpread, inputType);
            }
            case BLOCK_MEAN: {
                return FactoryThresholdBinary.blockMean(config.width, config.scale, config.down, config.thresholdFromLocalBlocks, inputType);
            }
            case BLOCK_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                return FactoryThresholdBinary.blockOtsu(c.width, c.scale, c.down, c.thresholdFromLocalBlocks, c.useOtsu2, c.tuning, inputType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)config.type));
    }
}

