/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveDown;
import boofcv.abst.filter.convolve.GenericConvolveDown;
import boofcv.abst.filter.convolve.PlanarConvolveDown;
import boofcv.alg.filter.convolve.ConvolveImageDownNoBorder;
import boofcv.alg.filter.convolve.ConvolveImageDownNormalized;
import boofcv.struct.border.BorderType;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import boofcv.testing.BoofTesting;
import java.lang.reflect.Method;

public class FactoryConvolveDown {
    public static <In extends ImageBase<In>, Out extends ImageBase<Out>> ConvolveDown<In, Out> convolve(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, ImageType<In> inputType, ImageType<Out> outputType) {
        switch (inputType.getFamily()) {
            case PLANAR: {
                return FactoryConvolveDown.convolvePL(kernel, border, isHorizontal, skip, inputType.getNumBands(), inputType.getImageClass(), outputType.getImageClass());
            }
            case GRAY: {
                return FactoryConvolveDown.convolveSB(kernel, border, isHorizontal, skip, inputType.getImageClass(), outputType.getImageClass());
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Interleaved images are not yet supported");
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>> ConvolveDown<In, Out> convolve(Kernel2D kernel, BorderType border, int skip, ImageType<In> inputType, ImageType<Out> outputType) {
        switch (inputType.getFamily()) {
            case PLANAR: {
                return FactoryConvolveDown.convolvePL(kernel, border, skip, inputType.getNumBands(), inputType.getImageClass(), outputType.getImageClass());
            }
            case GRAY: {
                return FactoryConvolveDown.convolveSB(kernel, border, skip, inputType.getImageClass(), outputType.getImageClass());
            }
            case INTERLEAVED: {
                throw new IllegalArgumentException("Interleaved images are not yet supported");
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> GenericConvolveDown<Input, Output> convolveSB(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, Class<Input> inputType, Class<Output> outputType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        String direction = isHorizontal ? "horizontal" : "vertical";
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveImageDownNoBorder.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    m = ConvolveImageDownNormalized.class.getMethod(direction, kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + border);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, (KernelBase)kernel, border, skip, ImageType.single(inputType), ImageType.single((Class)outputType));
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> GenericConvolveDown<Input, Output> convolveSB(Kernel2D kernel, BorderType border, int skip, Class<Input> inputType, Class<Output> outputType) {
        Method m;
        outputType = (Class)BoofTesting.convertToGenericType(outputType);
        try {
            switch (border) {
                case SKIP: {
                    m = ConvolveImageDownNoBorder.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                case EXTENDED: {
                    throw new IllegalArgumentException("Extended border is currently not supported.");
                }
                case NORMALIZED: {
                    m = ConvolveImageDownNormalized.class.getMethod("convolve", kernel.getClass(), inputType, outputType, Integer.TYPE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown border type " + border);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The specified convolution cannot be found");
        }
        return new GenericConvolveDown(m, (KernelBase)kernel, border, skip, ImageType.single(inputType), ImageType.single((Class)outputType));
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ConvolveDown<Planar<Input>, Planar<Output>> convolvePL(Kernel1D kernel, BorderType border, boolean isHorizontal, int skip, int numBands, Class<Input> inputType, Class<Output> outputType) {
        GenericConvolveDown<Input, Output> grayDown = FactoryConvolveDown.convolveSB(kernel, border, isHorizontal, skip, inputType, outputType);
        return new PlanarConvolveDown<Input, Output>(grayDown, numBands);
    }

    public static <Input extends ImageGray<Input>, Output extends ImageGray<Output>> ConvolveDown<Planar<Input>, Planar<Output>> convolvePL(Kernel2D kernel, BorderType border, int skip, int numBands, Class<Input> inputType, Class<Output> outputType) {
        GenericConvolveDown<Input, Output> grayDown = FactoryConvolveDown.convolveSB(kernel, border, skip, inputType, outputType);
        return new PlanarConvolveDown<Input, Output>(grayDown, numBands);
    }
}

