/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.kernel;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import java.util.Arrays;
import java.util.Random;

public class FactoryKernel {
    public static <T extends KernelBase> T createKernelForImage(int width, int offset, int DOF, ImageDataType type) {
        boolean isFloat = !type.isInteger();
        int numBits = Math.max(32, type.getNumBits());
        return FactoryKernel.createKernel(width, offset, DOF, isFloat, numBits);
    }

    public static <T extends KernelBase> T createKernelForImage(int width, int offset, int DOF, Class imageType) {
        boolean isFloat = GeneralizedImageOps.isFloatingPoint((Class)imageType);
        int numBits = Math.max(32, GeneralizedImageOps.getNumBits((Class)imageType));
        return FactoryKernel.createKernel(width, offset, DOF, isFloat, numBits);
    }

    public static <T extends KernelBase> T createKernel(int width, int offset, int DOF, boolean isFloat, int numBits) {
        if (DOF == 1) {
            if (isFloat) {
                if (numBits == 32) {
                    return (T)new Kernel1D_F32(width, offset);
                }
                if (numBits == 64) {
                    return (T)new Kernel1D_F64(width, offset);
                }
            } else if (numBits == 32) {
                return (T)new Kernel1D_S32(width, offset);
            }
        } else if (DOF == 2) {
            if (isFloat) {
                if (numBits == 32) {
                    return (T)new Kernel2D_F32(width, offset);
                }
                if (numBits == 64) {
                    return (T)new Kernel2D_F64(width, offset);
                }
            } else if (numBits == 32) {
                return (T)new Kernel2D_S32(width, offset);
            }
        }
        throw new IllegalArgumentException("Unsupported specifications. DOF = " + DOF + " float = " + isFloat + " bits = " + numBits);
    }

    public static Kernel1D createKernel1D(int offset, int[] data, Class kernelType) {
        Kernel1D_F32 out;
        if (kernelType == Kernel1D_F32.class) {
            out = new Kernel1D_F32(data.length, offset);
        } else if (kernelType == Kernel1D_F64.class) {
            out = new Kernel1D_F64(data.length, offset);
        } else if (kernelType == Kernel1D_S32.class) {
            out = new Kernel1D_S32(data.length, offset);
        } else {
            throw new RuntimeException("Unknown kernel type " + kernelType.getSimpleName());
        }
        for (int i = 0; i < data.length; ++i) {
            out.setD(i, (double)data[i]);
        }
        return out;
    }

    public static void setTable(KernelBase kernel) {
        if (kernel instanceof Kernel2D_F32) {
            Kernel2D_F32 k = (Kernel2D_F32)kernel;
            Arrays.fill(k.data, 1.0f / (float)(k.width * k.width));
        } else if (kernel instanceof Kernel2D_F64) {
            Kernel2D_F64 k = (Kernel2D_F64)kernel;
            Arrays.fill(k.data, 1.0 / (double)(k.width * k.width));
        } else if (kernel instanceof Kernel2D_S32) {
            Kernel2D_S32 k = (Kernel2D_S32)kernel;
            Arrays.fill(k.data, 1);
        }
    }

    public static Kernel1D_S32 table1D_I32(int radius) {
        Kernel1D_S32 ret = new Kernel1D_S32(radius * 2 + 1);
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = 1;
        }
        return ret;
    }

    public static Kernel1D_F32 table1D_F32(int radius, boolean normalized) {
        Kernel1D_F32 ret = new Kernel1D_F32(radius * 2 + 1);
        float val = normalized ? 1.0f / (float)ret.width : 1.0f;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = val;
        }
        return ret;
    }

    public static Kernel1D_F64 table1D_F64(int radius, boolean normalized) {
        Kernel1D_F64 ret = new Kernel1D_F64(radius * 2 + 1);
        double val = normalized ? 1.0 / (double)ret.width : 1.0;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = val;
        }
        return ret;
    }

    public static <T extends KernelBase> T random(Class<?> type, int radius, int min, int max, Random rand) {
        int width = radius * 2 + 1;
        return FactoryKernel.random(type, width, radius, min, max, rand);
    }

    public static <T extends KernelBase> T random(Class<?> type, int width, int offset, int min, int max, Random rand) {
        if (Kernel1D_F32.class == type) {
            return (T)FactoryKernel.random1D_F32(width, offset, min, max, rand);
        }
        if (Kernel1D_F64.class == type) {
            return (T)FactoryKernel.random1D_F64(width, offset, min, max, rand);
        }
        if (Kernel1D_S32.class == type) {
            return (T)FactoryKernel.random1D_I32(width, offset, min, max, rand);
        }
        if (Kernel2D_S32.class == type) {
            return (T)FactoryKernel.random2D_I32(width, offset, min, max, rand);
        }
        if (Kernel2D_F32.class == type) {
            return (T)FactoryKernel.random2D_F32(width, offset, min, max, rand);
        }
        if (Kernel2D_F64.class == type) {
            return (T)FactoryKernel.random2D_F64(width, offset, min, max, rand);
        }
        throw new RuntimeException("Unknown kernel type. " + type.getSimpleName());
    }

    public static Kernel1D_S32 random1D_I32(int width, int offset, int min, int max, Random rand) {
        Kernel1D_S32 ret = new Kernel1D_S32(width, offset);
        int range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextInt(range) + min;
        }
        return ret;
    }

    public static Kernel1D_F32 random1D_F32(int width, int offset, float min, float max, Random rand) {
        Kernel1D_F32 ret = new Kernel1D_F32(width, offset);
        float range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextFloat() * range + min;
        }
        return ret;
    }

    public static Kernel1D_F64 random1D_F64(int width, int offset, double min, double max, Random rand) {
        Kernel1D_F64 ret = new Kernel1D_F64(width, offset);
        double range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextDouble() * range + min;
        }
        return ret;
    }

    public static Kernel2D_S32 random2D_I32(int width, int offset, int min, int max, Random rand) {
        Kernel2D_S32 ret = new Kernel2D_S32(width, offset);
        int range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextInt(range) + min;
        }
        return ret;
    }

    public static Kernel2D_F32 random2D_F32(int width, int offset, float min, float max, Random rand) {
        Kernel2D_F32 ret = new Kernel2D_F32(width, offset);
        float range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextFloat() * range + min;
        }
        return ret;
    }

    public static Kernel2D_F64 random2D_F64(int width, int offset, double min, double max, Random rand) {
        Kernel2D_F64 ret = new Kernel2D_F64(width, offset);
        double range = max - min;
        for (int i = 0; i < ret.data.length; ++i) {
            ret.data[i] = rand.nextDouble() * range + min;
        }
        return ret;
    }

    public static <K1 extends Kernel1D, K2 extends Kernel2D> Class<K1> get1DType(Class<K2> kernelType) {
        if (kernelType == Kernel2D_F32.class) {
            return Kernel1D_F32.class;
        }
        return Kernel1D_S32.class;
    }

    public static <K extends KernelBase, T extends ImageGray> Class<K> getKernelType(ImageDataType type, int DOF) {
        if (type == ImageDataType.F32) {
            if (DOF == 1) {
                return Kernel1D_F32.class;
            }
            return Kernel2D_F32.class;
        }
        if (type.isInteger()) {
            if (DOF == 1) {
                return Kernel1D_S32.class;
            }
            return Kernel2D_S32.class;
        }
        throw new IllegalArgumentException("Unknown image type: " + type);
    }

    public static <K extends KernelBase, T extends ImageGray> Class<K> getKernelType(Class<T> imageType, int DOF) {
        return FactoryKernel.getKernelType(ImageDataType.classToType(imageType), DOF);
    }
}

