/*
 * Decompiled with CFR 0.152.
 */
package net.damango.pub.genparser;

import java.util.Enumeration;
import java.util.Hashtable;
import net.damango.pub.genparser.BranchStack;
import net.damango.pub.genparser.GenHandler;
import net.damango.widgets.stacks.StringStack;

public class Branch {
    public static final String TYPE = "GENtype";
    public static final String COUNT = "GENcount";
    public static final String ATTRIBUTES = "GENatts";
    public static final String DOC_TYPE = "GENdocument_type";
    public static final String ROOT = "root";
    public static final String BRANCH = "branch";
    public static final String EMPTY_BRANCH = "empty_branch";
    public static final String LEAF = "leaf";
    private Hashtable myBranch;
    private String myType;
    private int myIndex;

    public Branch() {
        this.myBranch = new Hashtable();
        this.myType = EMPTY_BRANCH;
        this.myBranch.put(TYPE, this.myType);
        this.myIndex = 0;
        this.myBranch.put(COUNT, new Integer(this.myIndex));
    }

    public Branch(Hashtable input) {
        this.myBranch = (Hashtable)input.clone();
        this.myType = (String)this.myBranch.remove(TYPE);
        this.myIndex = this.myBranch.containsKey(COUNT) ? (Integer)this.myBranch.get(COUNT) : 0;
        if (this.myBranch.containsKey(DOC_TYPE)) {
            this.myBranch.remove(DOC_TYPE);
        }
    }

    public void setType(String input) {
        if (input != null && !input.equals("") && (input.equals(ROOT) || input.equals(BRANCH) || input.equals(EMPTY_BRANCH) || input.equals(LEAF))) {
            this.myType = new String(input);
            if (this.myBranch == null) {
                this.myBranch = new Hashtable();
            }
            this.myBranch.remove(TYPE);
            this.myBranch.put(TYPE, this.myType);
        }
    }

    public void setDocType(String input) {
        if (input != null && !input.equals("")) {
            this.myType = new String(ROOT);
            if (this.myBranch == null) {
                this.myBranch = new Hashtable();
            }
            this.myBranch.remove(TYPE);
            this.myBranch.put(TYPE, this.myType);
            this.myBranch.remove(DOC_TYPE);
            this.myBranch.put(DOC_TYPE, input);
        } else {
            this.myType = new String(EMPTY_BRANCH);
            if (this.myBranch == null) {
                this.myBranch = new Hashtable();
            }
            this.myBranch.remove(TYPE);
            this.myBranch.put(TYPE, this.myType);
            this.myBranch.remove(DOC_TYPE);
        }
    }

    public void setCount(int input) {
        if (input >= 0) {
            this.myIndex = input;
            this.myBranch.remove(COUNT);
            this.myBranch.put(COUNT, new Integer(this.myIndex));
        }
    }

    public Branch[] getBranches(String type) {
        StringStack indexes = new StringStack();
        StringStack matchKeys = new StringStack();
        BranchStack matches = new BranchStack();
        indexes.push(type);
        String current = new String("");
        Enumeration elems = this.myBranch.keys();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!indexes.containsNoNum(current)) continue;
            matches.push(new Branch((Hashtable)this.myBranch.get(current)));
            matchKeys.push(current);
        }
        int many = matches.size();
        Branch[] output = new Branch[many];
        for (int i = 0; i < many; ++i) {
            output[i] = new Branch((Hashtable)this.myBranch.get(matchKeys.pop()));
        }
        return output;
    }

    public Branch getBranch(String type) {
        StringStack indexes = new StringStack();
        StringStack matchKeys = new StringStack();
        indexes.push(type);
        String current = new String("");
        Enumeration elems = this.myBranch.keys();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!indexes.containsNoNum(current)) continue;
            return new Branch((Hashtable)this.myBranch.get(current));
        }
        return null;
    }

    public String getInfo(String type) {
        Hashtable storage = new Hashtable();
        if (this.myBranch.containsKey(type)) {
            storage = (Hashtable)this.myBranch.get(type);
        }
        if (storage.containsKey(type)) {
            return (String)storage.get(type);
        }
        return "";
    }

    public String setInfo(String type, String data) {
        String output = new String("");
        if (this.myBranch.containsKey(type)) {
            if (((Hashtable)this.myBranch.get(type)).containsKey(type)) {
                output = (String)((Hashtable)this.myBranch.get(type)).remove(type);
            }
            ((Hashtable)this.myBranch.get(type)).put(type, data);
        } else {
            Branch new_branch = new Branch();
            new_branch.setType(LEAF);
            new_branch.getData().put(type, data);
            this.addBranch(type, new_branch);
        }
        return output;
    }

    public String getAttribute(String name) {
        Hashtable storage = new Hashtable();
        if (this.myBranch.containsKey(ATTRIBUTES)) {
            storage = (Hashtable)this.myBranch.get(ATTRIBUTES);
        }
        if (storage.containsKey(name)) {
            return (String)storage.get(name);
        }
        return "";
    }

    public String setAttribute(String name, String value) {
        String output = new String("");
        if (this.myBranch.containsKey(ATTRIBUTES)) {
            if (((Hashtable)this.myBranch.get(ATTRIBUTES)).containsKey(name)) {
                output = (String)((Hashtable)this.myBranch.get(ATTRIBUTES)).remove(name);
            }
            ((Hashtable)this.myBranch.get(ATTRIBUTES)).put(name, value);
        } else {
            Hashtable<String, String> tmp_hash = new Hashtable<String, String>();
            tmp_hash.put(name, value);
            this.myBranch.put(ATTRIBUTES, tmp_hash);
        }
        return output;
    }

    public boolean addBranch(String label, Branch input) {
        try {
            String type = GenHandler.swhich(this.myBranch, label);
            Hashtable temp = (Hashtable)input.getData().clone();
            int count = 0;
            int diff = 1;
            if (this.myBranch.containsKey(ATTRIBUTES)) {
                ++diff;
            }
            if (this.myBranch.containsKey(COUNT)) {
                ++diff;
            }
            count = this.myBranch.size() - diff;
            temp.remove(COUNT);
            temp.put(COUNT, new Integer(count));
            this.myBranch.put(type, temp);
            if (this.myType.equals(LEAF)) {
                this.myBranch.remove(TYPE);
                this.myBranch.put(TYPE, BRANCH);
                this.myType = new String(BRANCH);
            }
            if (this.myType.equals(EMPTY_BRANCH)) {
                this.myBranch.remove(TYPE);
                this.myBranch.put(TYPE, BRANCH);
                this.myType = new String(BRANCH);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean removeBranch(String label) {
        try {
            if (this.myBranch.containsKey(label)) {
                this.myBranch.remove(label);
                if (this.isEmpty()) {
                    this.setType(EMPTY_BRANCH);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEmpty() {
        if (this.myBranch == null || this.myBranch.size() < 1) {
            return true;
        }
        Enumeration keys = this.myBranch.keys();
        int ct = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(TYPE) || key.equals(COUNT) || key.equals(ATTRIBUTES) || key.equals(DOC_TYPE)) continue;
            ++ct;
        }
        return ct <= 0;
    }

    public Hashtable getData() {
        return this.myBranch;
    }
}

