/*
 * Decompiled with CFR 0.152.
 */
package net.damango.pub.genparser;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.damango.pub.genparser.Branch;
import net.damango.pub.genparser.GenHandler;
import net.damango.pub.genparser.GenParser;
import net.damango.pub.genparser.GenParserException;
import net.damango.widgets.textstuff.ZipUp;

public class DocumentHolder {
    private Hashtable document;
    private String file = "";
    private GenParser gp;
    private String dtd;
    private ZipUp z;

    public DocumentHolder() {
        this.gp = new GenParser();
        this.document = new Hashtable();
        this.z = new ZipUp();
        this.dtd = new String("");
    }

    public DocumentHolder(String name) {
        this.gp = new GenParser();
        this.document = new Hashtable();
        this.document.put("GENdocument_type", name);
        this.document.put("GENtype", "root");
        this.z = new ZipUp();
        this.dtd = new String("");
    }

    public DocumentHolder(String name, String parser_class) {
        this.gp = new GenParser(parser_class);
        this.document = new Hashtable();
        if (name != null && !name.equals("")) {
            this.document.put("GENdocument_type", name);
            this.document.put("GENtype", "root");
        }
        this.z = new ZipUp();
        this.dtd = new String("");
    }

    public void parseGZXMLFile(String inFile) throws Exception {
        this.parseGZXMLFile(new File(inFile));
    }

    public void parseGZXMLFile(File inFile) throws Exception {
        String inFileName = inFile.getAbsolutePath();
        File outF = new File(inFileName + ".tmp");
        if (!this.z.readWrite(inFile, outF)) {
            throw new GenParserException("Locally storing file failed!");
        }
        if (!this.gp.parseXMLFile(outF)) {
            throw new GenParserException("Parse failed!");
        }
        if (outF.exists()) {
            outF.delete();
        }
        this.document = (Hashtable)this.gp.getDocument().clone();
    }

    public void parseXMLFile(String filename) throws GenParserException {
        this.file = new String(filename);
        if (!this.gp.parseXMLFile(this.file)) {
            throw new GenParserException("Parse failed!");
        }
        this.document = (Hashtable)this.gp.getDocument().clone();
    }

    public void parseXML(String input) throws GenParserException {
        if (!this.gp.parseXML(input)) {
            throw new GenParserException("Parse failed!");
        }
        this.document = (Hashtable)this.gp.getDocument().clone();
    }

    public void parseXML(byte[] input) throws GenParserException {
        try {
            if (!this.gp.parseXML(input)) {
                throw new GenParserException("Parse failed!");
            }
        }
        catch (GenParserException gpe) {
            throw new GenParserException(gpe);
        }
        this.document = (Hashtable)this.gp.getDocument().clone();
    }

    public boolean merge(DocumentHolder newDH) {
        return false;
    }

    public Hashtable getDocument() {
        return this.document;
    }

    public Branch getBranch(String type) {
        return new Branch(this.document).getBranch(type);
    }

    public Branch[] getBranches(String type) {
        return new Branch(this.document).getBranches(type);
    }

    public String setInfo(String type, String data) {
        String output = new String("");
        if (this.document.containsKey(type)) {
            if (((Hashtable)this.document.get(type)).containsKey(type)) {
                output = (String)((Hashtable)this.document.get(type)).remove(type);
            }
            ((Hashtable)this.document.get(type)).put(type, data);
        } else {
            Branch new_branch = new Branch();
            new_branch.setType("leaf");
            new_branch.getData().put(type, data);
            this.addBranch(type, new_branch);
        }
        return output;
    }

    public String getInfo(String type) {
        Hashtable storage = new Hashtable();
        if (this.document.containsKey(type)) {
            storage = (Hashtable)this.document.get(type);
        }
        if (storage.containsKey(type)) {
            return (String)storage.get(type);
        }
        return "";
    }

    public boolean addBranch(String label, Branch input) {
        try {
            String type = GenHandler.swhich(this.document, label);
            Hashtable temp = (Hashtable)input.getData().clone();
            int count = 0;
            int diff = 2;
            if (this.document.containsKey("GENatts")) {
                ++diff;
            }
            if (this.document.containsKey("GENcount")) {
                ++diff;
            }
            count = this.document.size() - diff;
            temp.remove("GENcount");
            temp.put("GENcount", new Integer(count));
            this.document.put(type, temp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean removeBranch(String label) {
        try {
            if (this.document.containsKey(label)) {
                this.document.remove(label);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getAttribute(String name) {
        Hashtable storage = new Hashtable();
        if (this.document.containsKey("GENatts")) {
            storage = (Hashtable)this.document.get("GENatts");
        }
        if (storage.containsKey(name)) {
            return (String)storage.get(name);
        }
        return "";
    }

    public String setAttribute(String name, String value) {
        String output = new String("");
        if (this.document.containsKey("GENatts")) {
            if (((Hashtable)this.document.get("GENatts")).containsKey(name)) {
                output = (String)((Hashtable)this.document.get("GENatts")).remove(name);
            }
            ((Hashtable)this.document.get("GENatts")).put(name, value);
        } else {
            Hashtable<String, String> tmp_hash = new Hashtable<String, String>();
            tmp_hash.put(name, value);
            this.document.put("GENatts", tmp_hash);
        }
        return output;
    }

    public String toString() {
        String full = new String("");
        full = full.concat(this.dtd);
        full = full.concat(this.descend("", this.document, (String)this.document.get("GENdocument_type")));
        return full;
    }

    public String descend(String tabs, Hashtable tree, String name) {
        name = this.stripNum(name);
        Enumeration kys = tree.keys();
        String full = new String("");
        if (((String)tree.get("GENtype")).equals("empty_branch")) {
            if (tree.containsKey("GENatts")) {
                Hashtable atlst = (Hashtable)tree.get("GENatts");
                Enumeration titles = atlst.keys();
                String buf = new String("");
                full = full.concat(tabs + "<" + name);
                while (titles.hasMoreElements()) {
                    buf = new String((String)titles.nextElement());
                    full = full.concat(" " + buf + "=\"" + (String)atlst.get(buf) + "\"");
                }
                full = full.concat(" />\n");
            } else {
                full = full.concat(tabs + "<" + name + " />\n");
            }
        } else if (((String)tree.get("GENtype")).equals("branch")) {
            String[] keys = this.sort(tree);
            if (tree.containsKey("GENatts")) {
                Hashtable atlst = (Hashtable)tree.get("GENatts");
                Enumeration titles = atlst.keys();
                String buf = new String("");
                full = full.concat(tabs + "<" + name);
                while (titles.hasMoreElements()) {
                    buf = new String((String)titles.nextElement());
                    full = full.concat(" " + buf + "=\"" + (String)atlst.get(buf) + "\"");
                }
                full = full.concat(">\n");
            } else {
                full = full.concat(tabs + "<" + name + ">\n");
            }
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].equalsIgnoreCase("GENtype") || keys[i].equalsIgnoreCase("GENcount") || keys[i].equalsIgnoreCase("GENatts")) continue;
                full = full.concat(this.descend(tabs + "\t", (Hashtable)tree.get(keys[i]), keys[i]));
            }
            full = full.concat(tabs + "</" + name + ">\n");
        } else if (((String)tree.get("GENtype")).equals("leaf")) {
            String buffer = tree.containsKey(name) ? new String((String)tree.get(name)) : new String("");
            if (tree.containsKey("GENatts")) {
                Hashtable atlst = (Hashtable)tree.get("GENatts");
                Enumeration titles = atlst.keys();
                String buf = new String("");
                full = full.concat(tabs + "<" + name);
                while (titles.hasMoreElements()) {
                    buf = new String((String)titles.nextElement());
                    full = full.concat(" " + buf + "=\"" + (String)atlst.get(buf) + "\"");
                }
                full = full.concat(">" + buffer + "</" + name + ">\n");
            } else {
                full = full.concat(tabs + "<" + name + ">" + buffer + "</" + name + ">\n");
            }
        } else if (((String)tree.get("GENtype")).equals("root")) {
            String[] keys = this.sort(tree);
            if (tree.containsKey("GENatts")) {
                Hashtable atlst = (Hashtable)tree.get("GENatts");
                Enumeration titles = atlst.keys();
                String buf = new String("");
                full = full.concat(tabs + "<" + name);
                while (titles.hasMoreElements()) {
                    buf = new String((String)titles.nextElement());
                    full = full.concat(" " + buf + "=\"" + (String)atlst.get(buf) + "\"");
                }
                full = full.concat(">\n");
            } else {
                full = full.concat(tabs + "<" + name + ">\n");
            }
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].equalsIgnoreCase("GENtype") || keys[i].equalsIgnoreCase("GENcount") || keys[i].equalsIgnoreCase("GENdocument_type") || keys[i].equalsIgnoreCase("GENatts")) continue;
                full = full.concat(this.descend(tabs + "\t", (Hashtable)tree.get(keys[i]), keys[i]));
            }
            full = full.concat(tabs + "</" + name + ">\n");
        }
        return full;
    }

    public String stripNum(String input) {
        StringTokenizer bob = new StringTokenizer(input, "0123456789");
        return bob.nextToken();
    }

    public String[] sort(Hashtable tree) {
        Enumeration kys = tree.keys();
        String[] input = new String[tree.size()];
        int[] numbers = new int[tree.size()];
        int j = 0;
        while (kys.hasMoreElements()) {
            input[j] = new String((String)kys.nextElement());
            numbers[j] = input[j].equals("GENtype") ? -1 : (input[j].equals("GENdocument_type") ? -1 : (input[j].equals("GENcount") ? -1 : (input[j].equals("GENatts") ? -1 : (Integer)((Hashtable)tree.get(input[j])).get("GENcount"))));
            ++j;
        }
        return this.selectSort(numbers, input);
    }

    public String[] selectSort(int[] intInput, String[] stringInput) {
        int i;
        int noncombs = 0;
        boolean found = false;
        int many = stringInput.length;
        String[] output = new String[many];
        for (i = 0; i < many; ++i) {
            for (int j = 0; j < many; ++j) {
                if (intInput[j] != i) continue;
                output[i] = new String(stringInput[j]);
                found = true;
            }
            if (found) {
                found = false;
                continue;
            }
            if (i >= many - noncombs) continue;
            --i;
            ++noncombs;
        }
        if (noncombs > 0) {
            String[] tmp = new String[many - noncombs];
            for (i = 0; i < many - noncombs; ++i) {
                tmp[i] = new String(output[i]);
            }
            return tmp;
        }
        return output;
    }
}

