/*
 * Decompiled with CFR 0.152.
 */
package net.damango.widgets.stacks;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringStack {
    private Properties daStack = new Properties();
    private int top = 0;

    public String pop() {
        if (this.top == 0) {
            return "";
        }
        if (this.daStack.containsKey(new Integer(this.top))) {
            String output = (String)this.daStack.remove(new Integer(this.top));
            --this.top;
            return output;
        }
        return "";
    }

    public void push(String input) {
        ++this.top;
        this.daStack.put(new Integer(this.top), input);
    }

    public String peek() {
        if (this.daStack.containsKey(new Integer(this.top))) {
            return (String)this.daStack.get(new Integer(this.top));
        }
        return "";
    }

    public boolean contains(String input) {
        String current = new String("");
        Enumeration<Object> elems = this.daStack.elements();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!input.equals(current)) continue;
            return true;
        }
        return false;
    }

    public String containsPrefix(String input, boolean pushy) {
        String output = this.containsPrefix(input);
        if (pushy && output.equals(input) && !this.contains(input)) {
            this.push(input);
        }
        return output;
    }

    public String containsPrefix(String input) {
        String current = new String("");
        Enumeration<Object> elems = this.daStack.elements();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!input.startsWith(current)) continue;
            return current;
        }
        return input;
    }

    public boolean containsBeginning(String input) {
        String current = new String("");
        Enumeration<Object> elems = this.daStack.elements();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!input.startsWith(current)) continue;
            return true;
        }
        return false;
    }

    public boolean containsNoNum(String input) {
        String current = new String("");
        Enumeration<Object> elems = this.daStack.elements();
        while (elems.hasMoreElements()) {
            current = (String)elems.nextElement();
            if (!StringStack.stripNum(input).equalsIgnoreCase(current)) continue;
            return true;
        }
        return false;
    }

    public static String stripNum(String input) {
        StringTokenizer bob = new StringTokenizer(input, "0123456789");
        return bob.nextToken();
    }

    public String toString() {
        String output = new String("");
        Enumeration<Object> elems = this.daStack.elements();
        while (elems.hasMoreElements()) {
            output = output.concat((String)elems.nextElement());
            output = output.concat(":>>");
        }
        return output;
    }

    public int size() {
        return this.daStack.size();
    }
}

