/*
 * Decompiled with CFR 0.152.
 */
package net.damango.widgets.textstuff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.damango.widgets.textstuff.ByteArrayTool;

public class ZipUp {
    private GZIPInputStream is;
    private GZIPOutputStream os;
    private FileOutputStream fos;
    private byte[] inputStr = new byte[0];
    private byte[] tmpInput = new byte[80];
    private byte[] tmpStorage = new byte[0];
    private ByteArrayTool bat;
    private String curInFilename = new String("");
    private String curOutFilename = new String("");
    private boolean readFileSet = false;

    public boolean setCompressedFileToRead(String inFilename) throws Exception {
        this.curInFilename = new String(inFilename);
        return this.setCompressedFileToRead(new File(inFilename));
    }

    public boolean setCompressedFileToRead(File inFile) throws Exception {
        int whatIGot = 0;
        this.is = new GZIPInputStream(new FileInputStream(inFile));
        while ((whatIGot = this.is.read(this.tmpInput, 0, 80)) != -1) {
            int i;
            this.tmpStorage = new byte[this.inputStr.length + whatIGot];
            for (i = 0; i < this.inputStr.length; ++i) {
                this.tmpStorage[i] = this.inputStr[i];
            }
            i = 0;
            for (int j = this.inputStr.length; j < this.tmpStorage.length; ++j) {
                this.tmpStorage[j] = this.tmpInput[i];
                ++i;
            }
            this.inputStr = new byte[this.tmpStorage.length];
            for (i = 0; i < this.tmpStorage.length; ++i) {
                this.inputStr[i] = this.tmpStorage[i];
            }
        }
        this.bat = new ByteArrayTool(this.inputStr);
        this.readFileSet = true;
        return true;
    }

    public boolean readWrite(File inFile, String outFilename) throws Exception {
        return this.readWrite(inFile, new File(outFilename));
    }

    public boolean readWrite(String inFilename, File outFile) throws Exception {
        return this.readWrite(new File(inFilename), outFile);
    }

    public boolean readWrite(String inFilename, String outFilename) throws Exception {
        return this.readWrite(new File(inFilename), new File(outFilename));
    }

    public boolean readWrite(File inFile, File outFile) throws Exception {
        if (!this.setCompressedFileToRead(inFile)) {
            return false;
        }
        String buffer = new String("");
        String tmp = new String("");
        while ((tmp = this.bat.readLine()) != null) {
            buffer = buffer + tmp + "\n";
        }
        this.startOver();
        this.fos = new FileOutputStream(outFile);
        this.fos.write(buffer.getBytes());
        this.fos.close();
        return true;
    }

    public String readLine() {
        if (!this.readFileSet) {
            return null;
        }
        if (this.bat != null) {
            return this.bat.readLine();
        }
        return null;
    }

    public String readAll() {
        if (!this.readFileSet) {
            return null;
        }
        String buffer = new String("");
        String tmp = new String("");
        this.startOver();
        while ((tmp = this.bat.readLine()) != null) {
            buffer = buffer + tmp;
        }
        this.startOver();
        return buffer;
    }

    public byte[] getBytes() {
        if (!this.readFileSet) {
            return null;
        }
        return this.readAll().getBytes();
    }

    public byte[] getByteLine() {
        if (!this.readFileSet) {
            return null;
        }
        String buffer = this.readLine();
        if (buffer == null) {
            return null;
        }
        return buffer.getBytes();
    }

    public void startOver() {
        if (this.readFileSet) {
            this.bat.resetLine();
        }
    }

    public boolean write(String inFilename) {
        this.curInFilename = new String(inFilename);
        this.curOutFilename = new String(inFilename + ".gz");
        return this.write(new File(inFilename), inFilename + ".gz");
    }

    public boolean write(File inFile, File outFile) {
        String buffer = new String("");
        String total = new String("");
        try {
            RandomAccessFile fin = new RandomAccessFile(inFile, "r");
            while ((buffer = fin.readLine()) != null) {
                total = total + buffer + "\n";
            }
        }
        catch (Exception e) {
            return false;
        }
        return this.write(total, outFile);
    }

    public boolean write(File inFile, String outFilename) {
        this.curOutFilename = new String(outFilename);
        return this.write(inFile, new File(outFilename));
    }

    public boolean write(String input, File outFile) {
        return this.write(input.getBytes(), outFile);
    }

    public boolean write(String input, String outFilename) {
        this.curOutFilename = new String(outFilename);
        return this.write(input.getBytes(), outFilename);
    }

    public boolean write(byte[] input, String outFilename) {
        this.curOutFilename = new String(outFilename);
        return this.write(input, new File(outFilename));
    }

    public boolean write(byte[] input, File outFile) {
        try {
            this.os = new GZIPOutputStream(new FileOutputStream(outFile));
            this.os.write(input, 0, input.length);
            this.os.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

