/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.nn.KdTreePoint3D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class PruneStructureFromSceneMetric {
    SceneStructureMetric structure;
    SceneObservations observations;

    public PruneStructureFromSceneMetric(SceneStructureMetric structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
    }

    public void pruneObservationsByErrorRank(double inlierFraction) {
        Point2D_F64 observation = new Point2D_F64();
        Point2D_F64 predicted = new Point2D_F64();
        Point3D_F64 X = new Point3D_F64();
        ArrayList<Errors> errors = new ArrayList<Errors>();
        for (int viewIndex = 0; viewIndex < this.observations.views.length; ++viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            SceneStructureMetric.View view = this.structure.views[viewIndex];
            int pointIndex = 0;
            while (pointIndex < v.point.size) {
                int pointID = v.point.data[pointIndex];
                SceneStructureCommon.Point f = this.structure.points[pointID];
                f.get(X);
                v.get(pointIndex, observation);
                view.worldToView.transform(X, X);
                SceneStructureMetric.Camera camera = this.structure.cameras[view.camera];
                camera.model.project(X.x, X.y, X.z, predicted);
                Errors e = new Errors();
                e.view = viewIndex;
                e.pointIndexInView = pointIndex++;
                e.error = predicted.distance2((GeoTuple2D_F64)observation);
                errors.add(e);
            }
        }
        errors.sort(Comparator.comparingDouble(a -> a.error));
        for (int i = (int)((double)errors.size() * inlierFraction); i < errors.size(); ++i) {
            Errors e = (Errors)errors.get(i);
            SceneObservations.View v = this.observations.views[e.view];
            v.set(e.pointIndexInView, Float.NaN, Float.NaN);
        }
        this.removeMarkedObservations();
    }

    private void removeMarkedObservations() {
        Point2D_F64 observation = new Point2D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.length; ++viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            for (int pointIndex = v.point.size - 1; pointIndex >= 0; --pointIndex) {
                int pointID = v.getPointId(pointIndex);
                SceneStructureCommon.Point f = this.structure.points[pointID];
                v.get(pointIndex, observation);
                if (!Double.isNaN(observation.x)) continue;
                if (!f.views.contains(viewIndex)) {
                    throw new RuntimeException("BUG!");
                }
                f.removeView(viewIndex);
                v.remove(pointIndex);
            }
        }
    }

    public void pruneObservationsBehindCamera() {
        Point3D_F64 X = new Point3D_F64();
        for (int viewIndex = 0; viewIndex < this.observations.views.length; ++viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            SceneStructureMetric.View view = this.structure.views[viewIndex];
            for (int pointIndex = 0; pointIndex < v.point.size; ++pointIndex) {
                SceneStructureCommon.Point f = this.structure.points[v.getPointId(pointIndex)];
                f.get(X);
                if (!f.views.contains(viewIndex)) {
                    throw new RuntimeException("BUG!");
                }
                view.worldToView.transform(X, X);
                if (!(X.z <= 0.0)) continue;
                v.set(pointIndex, Float.NaN, Float.NaN);
            }
        }
        this.removeMarkedObservations();
    }

    public void prunePoints(int count) {
        for (int viewIndex = this.observations.views.length - 1; viewIndex >= 0; --viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            for (int pointIndex = v.point.size - 1; pointIndex >= 0; --pointIndex) {
                SceneStructureCommon.Point p = this.structure.points[v.getPointId(pointIndex)];
                if (p.views.size >= count) continue;
                v.remove(pointIndex);
            }
        }
        int[] oldToNew = new int[this.structure.points.length];
        Arrays.fill(oldToNew, -1);
        GrowQueue_I32 prune = new GrowQueue_I32();
        for (int i = 0; i < this.structure.points.length; ++i) {
            if (this.structure.points[i].views.size < count) {
                prune.add(i);
                continue;
            }
            oldToNew[i] = i - prune.size;
        }
        this.pruneUpdatePointID(oldToNew, prune);
    }

    private void pruneUpdatePointID(int[] oldToNew, GrowQueue_I32 prune) {
        if (prune.size == 0) {
            return;
        }
        this.structure.removePoints(prune);
        for (int viewIndex = this.observations.views.length - 1; viewIndex >= 0; --viewIndex) {
            SceneObservations.View v = this.observations.views[viewIndex];
            for (int featureIndex = v.point.size - 1; featureIndex >= 0; --featureIndex) {
                v.point.data[featureIndex] = oldToNew[v.point.data[featureIndex]];
            }
        }
    }

    public void prunePoints(int neighbors, double distance) {
        Point3D_F64 worldX = new Point3D_F64();
        ArrayList<Point3D_F64> cloud = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.structure.points.length; ++i) {
            SceneStructureCommon.Point structureP = this.structure.points[i];
            structureP.get(worldX);
            cloud.add(worldX.copy());
        }
        NearestNeighbor nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new KdTreePoint3D_F64());
        nn.setPoints(cloud, false);
        FastQueue resultsNN = new FastQueue(NnData.class, true);
        int[] oldToNew = new int[this.structure.points.length];
        Arrays.fill(oldToNew, -1);
        GrowQueue_I32 prunePointID = new GrowQueue_I32();
        for (int pointId = 0; pointId < this.structure.points.length; ++pointId) {
            SceneStructureCommon.Point structureP = this.structure.points[pointId];
            structureP.get(worldX);
            nn.findNearest(cloud.get(pointId), distance * distance, neighbors + 1, resultsNN);
            if (resultsNN.size() > neighbors) {
                oldToNew[pointId] = pointId - prunePointID.size;
                continue;
            }
            prunePointID.add(pointId);
            for (int viewIdx = 0; viewIdx < structureP.views.size; ++viewIdx) {
                SceneObservations.View v = this.observations.getView(structureP.views.data[viewIdx]);
                int pointIdx = v.point.indexOf(pointId);
                if (pointIdx < 0) {
                    throw new RuntimeException("Bad structure. Point not found in view's observation which was in its structure");
                }
                v.remove(pointIdx);
            }
        }
        this.pruneUpdatePointID(oldToNew, prunePointID);
    }

    public void pruneViews(int count) {
        ArrayList<SceneStructureMetric.View> remainingS = new ArrayList<SceneStructureMetric.View>();
        ArrayList<SceneObservations.View> remainingO = new ArrayList<SceneObservations.View>();
        for (int viewId = 0; viewId < this.structure.views.length; ++viewId) {
            SceneObservations.View view = this.observations.views[viewId];
            if (view.size() > count) {
                remainingS.add(this.structure.views[viewId]);
                remainingO.add(view);
                continue;
            }
            for (int pointIdx = 0; pointIdx < view.point.size; ++pointIdx) {
                int pointId = view.getPointId(pointIdx);
                int viewIdx = this.structure.points[pointId].views.indexOf(viewId);
                if (viewIdx < 0) {
                    throw new RuntimeException("Bug in structure. view has point but point doesn't have view");
                }
                this.structure.points[pointId].views.remove(viewIdx);
            }
        }
        this.structure.views = new SceneStructureMetric.View[remainingS.size()];
        this.observations.views = new SceneObservations.View[remainingO.size()];
        for (int i = 0; i < this.structure.views.length; ++i) {
            this.structure.views[i] = (SceneStructureMetric.View)remainingS.get(i);
            this.observations.views[i] = (SceneObservations.View)remainingO.get(i);
        }
    }

    public void pruneUnusedCameras() {
        int i;
        int[] histogram = new int[this.structure.cameras.length];
        for (int i2 = 0; i2 < this.structure.views.length; ++i2) {
            int n = this.structure.views[i2].camera;
            histogram[n] = histogram[n] + 1;
        }
        int[] oldToNew = new int[this.structure.cameras.length];
        ArrayList<SceneStructureMetric.Camera> remaining = new ArrayList<SceneStructureMetric.Camera>();
        for (i = 0; i < this.structure.cameras.length; ++i) {
            if (histogram[i] <= 0) continue;
            oldToNew[i] = remaining.size();
            remaining.add(this.structure.cameras[i]);
        }
        this.structure.cameras = new SceneStructureMetric.Camera[remaining.size()];
        for (i = 0; i < remaining.size(); ++i) {
            this.structure.cameras[i] = (SceneStructureMetric.Camera)remaining.get(i);
        }
        for (i = 0; i < this.structure.views.length; ++i) {
            SceneStructureMetric.View v = this.structure.views[i];
            v.camera = oldToNew[v.camera];
        }
    }

    private static class Errors {
        int view;
        int pointIndexInView;
        double error;

        private Errors() {
        }
    }
}

