/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;

public class SceneStructureMetric
extends SceneStructureCommon {
    public Camera[] cameras;
    public View[] views;
    public Rigid[] rigids;
    public int[] lookupRigid;

    public SceneStructureMetric(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        this.initialize(totalCameras, totalViews, totalPoints, 0);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints, int totalRigid) {
        int i;
        this.cameras = new Camera[totalCameras];
        this.views = new View[totalViews];
        this.points = new SceneStructureCommon.Point[totalPoints];
        this.rigids = new Rigid[totalRigid];
        for (i = 0; i < this.cameras.length; ++i) {
            this.cameras[i] = new Camera();
        }
        for (i = 0; i < this.views.length; ++i) {
            this.views[i] = new View();
        }
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
        for (i = 0; i < this.rigids.length; ++i) {
            this.rigids[i] = new Rigid();
        }
        this.lookupRigid = null;
    }

    public void assignIDsToRigidPoints() {
        if (this.lookupRigid != null) {
            return;
        }
        this.lookupRigid = new int[this.getTotalRigidPoints()];
        int pointID = 0;
        for (int i = 0; i < this.rigids.length; ++i) {
            Rigid r = this.rigids[i];
            r.indexFirst = pointID;
            int j = 0;
            while (j < r.points.length) {
                this.lookupRigid[pointID] = i;
                ++j;
                ++pointID;
            }
        }
    }

    public boolean hasRigid() {
        return this.rigids.length > 0;
    }

    public void setCamera(int which, boolean fixed, BundleAdjustmentCamera model) {
        this.cameras[which].known = fixed;
        this.cameras[which].model = model;
    }

    public void setCamera(int which, boolean fixed, CameraPinhole intrinsic) {
        this.setCamera(which, fixed, new BundlePinhole(intrinsic));
    }

    public void setCamera(int which, boolean fixed, CameraPinholeBrown intrinsic) {
        this.setCamera(which, fixed, new BundlePinholeBrown(intrinsic));
    }

    public void setView(int which, boolean fixed, Se3_F64 worldToView) {
        this.views[which].known = fixed;
        this.views[which].worldToView.set(worldToView);
    }

    public void setRigid(int which, boolean fixed, Se3_F64 worldToObject, int totalPoints) {
        Rigid r = this.rigids[which] = new Rigid();
        r.known = fixed;
        r.objectToWorld.set(worldToObject);
        r.points = new SceneStructureCommon.Point[totalPoints];
        for (int i = 0; i < totalPoints; ++i) {
            r.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (this.views[viewIndex].camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        this.views[viewIndex].camera = cameraIndex;
    }

    public int getUnknownCameraCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.length; ++i) {
            if (this.cameras[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownRigidCount() {
        int total = 0;
        for (int i = 0; i < this.rigids.length; ++i) {
            if (this.rigids[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownCameraParameterCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.length; ++i) {
            if (this.cameras[i].known) continue;
            total += this.cameras[i].model.getIntrinsicCount();
        }
        return total;
    }

    public int getTotalRigidPoints() {
        if (this.rigids == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < this.rigids.length; ++i) {
            total += this.rigids[i].points.length;
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 6 + this.getUnknownRigidCount() * 6 + this.points.length * this.pointSize + this.getUnknownCameraParameterCount();
    }

    public Camera[] getCameras() {
        return this.cameras;
    }

    public View[] getViews() {
        return this.views;
    }

    public Rigid[] getRigids() {
        return this.rigids;
    }

    public static class Rigid {
        public boolean known = false;
        public Se3_F64 objectToWorld = new Se3_F64();
        public SceneStructureCommon.Point[] points;
        public int indexFirst;

        public void setPoint(int which, double x, double y, double z) {
            this.points[which].set(x, y, z);
        }

        public void setPoint(int which, double x, double y, double z, double w) {
            this.points[which].set(x, y, z, w);
        }

        public void getPoint(int which, Point3D_F64 p) {
            this.points[which].get(p);
        }

        public void getPoint(int which, Point4D_F64 p) {
            this.points[which].get(p);
        }

        public int getTotalPoints() {
            return this.points.length;
        }
    }

    public static class View {
        public boolean known = true;
        public Se3_F64 worldToView = new Se3_F64();
        public int camera = -1;
    }

    public static class Camera {
        public boolean known = true;
        public BundleAdjustmentCamera model;

        public <T extends BundleAdjustmentCamera> T getModel() {
            return (T)this.model;
        }
    }
}

