/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.Point3Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class NarrowToWidePtoP_F64
implements Point2Transform2_F64 {
    DMatrixRMaj rotateWideToNarrow = CommonOps_DDRM.identity((int)3, (int)3);
    Point2Transform2_F64 narrowToNorm;
    Point3Transform2_F64 unitToWide;
    Point2D_F64 norm = new Point2D_F64();
    Point3D_F64 unit = new Point3D_F64();

    public NarrowToWidePtoP_F64() {
    }

    public NarrowToWidePtoP_F64(LensDistortionNarrowFOV narrow, LensDistortionWideFOV wide) {
        this.configure(narrow, wide);
    }

    public void configure(LensDistortionNarrowFOV narrow, LensDistortionWideFOV wide) {
        this.narrowToNorm = narrow.undistort_F64(true, false);
        this.unitToWide = wide.distortStoP_F64();
    }

    public void setRotationWideToNarrow(DMatrixRMaj R) {
        this.rotateWideToNarrow.set((DMatrixD1)R);
    }

    public void compute(double x, double y, Point2D_F64 out) {
        this.narrowToNorm.compute(x, y, this.norm);
        this.unit.set(this.norm.x, this.norm.y, 1.0);
        GeometryMath_F64.mult((DMatrixRMaj)this.rotateWideToNarrow, (GeoTuple3D_F64)this.unit, (GeoTuple3D_F64)this.unit);
        double n = this.unit.norm();
        this.unit.x /= n;
        this.unit.y /= n;
        this.unit.z /= n;
        this.unitToWide.compute(this.unit.x, this.unit.y, this.unit.z, out);
    }

    public Point2Transform2_F64 copy() {
        NarrowToWidePtoP_F64 ret = new NarrowToWidePtoP_F64();
        ret.narrowToNorm = this.narrowToNorm.copy();
        this.unitToWide = null;
        throw new RuntimeException("Implement unit to wide");
    }
}

