/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SafeSvd_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class DecomposeHomography {
    private SingularValueDecomposition<DMatrixRMaj> svd;
    List<Se3_F64> solutionsSE = new ArrayList<Se3_F64>();
    List<Vector3D_F64> solutionsN = new ArrayList<Vector3D_F64>();
    Vector3D_F64 u1 = new Vector3D_F64();
    Vector3D_F64 u2 = new Vector3D_F64();
    Vector3D_F64 v2 = new Vector3D_F64();
    Vector3D_F64 tempV = new Vector3D_F64();
    DMatrixRMaj W1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj W2 = new DMatrixRMaj(3, 3);
    DMatrixRMaj U1 = new DMatrixRMaj(3, 3);
    DMatrixRMaj U2 = new DMatrixRMaj(3, 3);
    DMatrixRMaj Hv2 = new DMatrixRMaj(3, 3);
    DMatrixRMaj tempM = new DMatrixRMaj(3, 3);
    DMatrixRMaj H = new DMatrixRMaj(3, 3);

    public DecomposeHomography() {
        for (int i = 0; i < 4; ++i) {
            this.solutionsN.add(new Vector3D_F64());
            this.solutionsSE.add(new Se3_F64());
        }
        this.svd = new SafeSvd_DDRM(DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)false, (boolean)true, (boolean)false));
    }

    public void decompose(DMatrixRMaj homography) {
        if (!this.svd.decompose((Matrix)homography)) {
            throw new RuntimeException("SVD failed somehow");
        }
        DMatrixRMaj V = (DMatrixRMaj)this.svd.getV(null, false);
        DMatrixRMaj S = (DMatrixRMaj)this.svd.getW(null);
        SingularOps_DDRM.descendingOrder(null, (boolean)false, (DMatrixRMaj)S, (DMatrixRMaj)V, (boolean)false);
        double s0 = S.get(0, 0);
        double s1 = S.get(1, 1);
        double s2 = S.get(2, 2);
        s0 /= s1;
        s2 /= s1;
        CommonOps_DDRM.scale((double)(1.0 / s1), (DMatrixD1)homography, (DMatrixD1)this.H);
        s0 *= s0;
        s2 *= s2;
        this.v2.set(V.get(0, 1), V.get(1, 1), V.get(2, 1));
        double a = Math.sqrt(1.0 - s2);
        double b = Math.sqrt(s0 - 1.0);
        double div = Math.sqrt(s0 - s2);
        for (int i = 0; i < 3; ++i) {
            double e1 = (a * V.get(i, 0) + b * V.get(i, 2)) / div;
            double e2 = (a * V.get(i, 0) - b * V.get(i, 2)) / div;
            this.u1.setIdx(i, e1);
            this.u2.setIdx(i, e2);
        }
        this.setU(this.U1, this.v2, this.u1);
        this.setU(this.U2, this.v2, this.u2);
        this.setW(this.W1, this.H, this.v2, this.u1);
        this.setW(this.W2, this.H, this.v2, this.u2);
        this.createSolution(this.W1, this.U1, this.u1, this.H, this.solutionsSE.get(0), this.solutionsN.get(0));
        this.createSolution(this.W2, this.U2, this.u2, this.H, this.solutionsSE.get(1), this.solutionsN.get(1));
        this.createMirrorSolution(0, 2);
        this.createMirrorSolution(1, 3);
    }

    public List<Se3_F64> getSolutionsSE() {
        return this.solutionsSE;
    }

    public List<Vector3D_F64> getSolutionsN() {
        return this.solutionsN;
    }

    private void setU(DMatrixRMaj U, Vector3D_F64 a, Vector3D_F64 b) {
        this.setColumn(U, 0, a);
        this.setColumn(U, 1, b);
        GeometryMath_F64.cross((GeoTuple3D_F64)a, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(U, 2, this.tempV);
    }

    private void setW(DMatrixRMaj W, DMatrixRMaj H, Vector3D_F64 a, Vector3D_F64 b) {
        GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 1, this.tempV);
        GeometryMath_F64.mult((DMatrixRMaj)H, (GeoTuple3D_F64)a, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 0, this.tempV);
        GeometryMath_F64.crossMatrix((GeoTuple3D_F64)this.tempV, (DMatrixRMaj)this.Hv2);
        CommonOps_DDRM.mult((DMatrix1Row)this.Hv2, (DMatrix1Row)H, (DMatrix1Row)this.tempM);
        GeometryMath_F64.mult((DMatrixRMaj)this.tempM, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this.tempV);
        this.setColumn(W, 2, this.tempV);
    }

    private void setColumn(DMatrixRMaj U, int column, Vector3D_F64 a) {
        U.set(0, column, a.x);
        U.set(1, column, a.y);
        U.set(2, column, a.z);
    }

    private void createSolution(DMatrixRMaj W, DMatrixRMaj U, Vector3D_F64 u, DMatrixRMaj H, Se3_F64 se, Vector3D_F64 N) {
        CommonOps_DDRM.multTransB((DMatrix1Row)W, (DMatrix1Row)U, (DMatrix1Row)se.getR());
        GeometryMath_F64.cross((GeoTuple3D_F64)this.v2, (GeoTuple3D_F64)u, (GeoTuple3D_F64)N);
        CommonOps_DDRM.subtract((DMatrixD1)H, (DMatrixD1)se.getR(), (DMatrixD1)this.tempM);
        GeometryMath_F64.mult((DMatrixRMaj)this.tempM, (GeoTuple3D_F64)N, (GeoTuple3D_F64)se.getT());
    }

    private void createMirrorSolution(int origIndex, int index) {
        Se3_F64 origSE = this.solutionsSE.get(origIndex);
        Vector3D_F64 origN = this.solutionsN.get(origIndex);
        Se3_F64 se = this.solutionsSE.get(index);
        Vector3D_F64 N = this.solutionsN.get(index);
        se.getR().set((DMatrixD1)origSE.getR());
        N.x = -origN.x;
        N.y = -origN.y;
        N.z = -origN.z;
        Vector3D_F64 origT = origSE.getT();
        Vector3D_F64 T = se.getT();
        T.x = -origT.x;
        T.y = -origT.y;
        T.z = -origT.z;
    }
}

