/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.CodecSceneStructureProjective;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;

public class BundleAdjustmentProjectiveResidualFunction
implements BundleAdjustmentSchur.FunctionResiduals<SceneStructureProjective> {
    private SceneStructureProjective structure;
    private SceneObservations observations;
    private int numParameters;
    private int numObservations;
    private Point2D_F64 predictedPixel = new Point2D_F64();
    private PointIndex2D_F64 observedPixel = new PointIndex2D_F64();
    private CodecSceneStructureProjective codec = new CodecSceneStructureProjective();
    private Point3D_F64 p3 = new Point3D_F64();
    private Point4D_F64 p4 = new Point4D_F64();

    @Override
    public void configure(SceneStructureProjective structure, SceneObservations observations) {
        this.structure = structure;
        this.observations = observations;
        this.numObservations = observations.getObservationCount();
        this.numParameters = structure.getParameterCount();
    }

    public int getNumOfInputsN() {
        return this.numParameters;
    }

    public int getNumOfOutputsM() {
        return this.numObservations * 2;
    }

    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.structure);
        if (this.structure.homogenous) {
            this.project4(output);
        } else {
            this.project3(output);
        }
    }

    private void project3(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.length; ++viewIndex) {
            SceneStructureProjective.View view = this.structure.views[viewIndex];
            SceneObservations.View obsView = this.observations.views[viewIndex];
            for (int i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = this.structure.points[this.observedPixel.index];
                worldPt.get(this.p3);
                PerspectiveOps.renderPixel(view.worldToView, this.p3, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
        }
    }

    private void project4(double[] output) {
        int observationIndex = 0;
        for (int viewIndex = 0; viewIndex < this.structure.views.length; ++viewIndex) {
            SceneStructureProjective.View view = this.structure.views[viewIndex];
            SceneObservations.View obsView = this.observations.views[viewIndex];
            for (int i = 0; i < obsView.size(); ++i) {
                obsView.get(i, this.observedPixel);
                SceneStructureCommon.Point worldPt = this.structure.points[this.observedPixel.index];
                worldPt.get(this.p4);
                PerspectiveOps.renderPixel(view.worldToView, this.p4, this.predictedPixel);
                int outputIndex = observationIndex * 2;
                output[outputIndex] = this.predictedPixel.x - this.observedPixel.x;
                output[outputIndex + 1] = this.predictedPixel.y - this.observedPixel.y;
                ++observationIndex;
            }
        }
    }
}

