/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3;
import boofcv.alg.geo.bundle.jacobians.JacobianSo3Rodrigues;
import org.ejml.data.DMatrixD1;

public class CodecSceneStructureMetric
implements BundleAdjustmentSchur.Codec<SceneStructureMetric> {
    public JacobianSo3 rotation = new JacobianSo3Rodrigues();

    public CodecSceneStructureMetric() {
    }

    public CodecSceneStructureMetric(JacobianSo3 rotation) {
        this.rotation = rotation;
    }

    @Override
    public void decode(double[] input, SceneStructureMetric structure) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.length; ++i) {
            SceneStructureCommon.Point p = structure.points[i];
            p.coordinate[0] = input[index++];
            p.coordinate[1] = input[index++];
            p.coordinate[2] = input[index++];
            if (!structure.isHomogenous()) continue;
            p.coordinate[3] = input[index++];
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.length; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = structure.rigids[rigidIndex];
            if (rigid.known) continue;
            this.rotation.setParameters(input, index);
            rigid.objectToWorld.R.set((DMatrixD1)this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            rigid.objectToWorld.T.x = input[index++];
            rigid.objectToWorld.T.y = input[index++];
            rigid.objectToWorld.T.z = input[index++];
        }
        for (int viewIndex = 0; viewIndex < structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = structure.views[viewIndex];
            if (view.known) continue;
            this.rotation.setParameters(input, index);
            view.worldToView.R.set((DMatrixD1)this.rotation.getRotationMatrix());
            index += this.rotation.getParameterLength();
            view.worldToView.T.x = input[index++];
            view.worldToView.T.y = input[index++];
            view.worldToView.T.z = input[index++];
        }
        for (i = 0; i < structure.cameras.length; ++i) {
            SceneStructureMetric.Camera camera = structure.cameras[i];
            if (camera.known) continue;
            camera.model.setIntrinsic(input, index);
            index += camera.model.getIntrinsicCount();
        }
    }

    @Override
    public void encode(SceneStructureMetric structure, double[] output) {
        int i;
        int index = 0;
        for (i = 0; i < structure.points.length; ++i) {
            SceneStructureCommon.Point p = structure.points[i];
            output[index++] = p.coordinate[0];
            output[index++] = p.coordinate[1];
            output[index++] = p.coordinate[2];
            if (!structure.isHomogenous()) continue;
            output[index++] = p.coordinate[3];
        }
        for (int rigidIndex = 0; rigidIndex < structure.rigids.length; ++rigidIndex) {
            SceneStructureMetric.Rigid rigid = structure.rigids[rigidIndex];
            if (rigid.known) continue;
            this.rotation.getParameters(rigid.objectToWorld.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = rigid.objectToWorld.T.x;
            output[index++] = rigid.objectToWorld.T.y;
            output[index++] = rigid.objectToWorld.T.z;
        }
        for (int viewIndex = 0; viewIndex < structure.views.length; ++viewIndex) {
            SceneStructureMetric.View view = structure.views[viewIndex];
            if (view.known) continue;
            this.rotation.getParameters(view.worldToView.R, output, index);
            index += this.rotation.getParameterLength();
            output[index++] = view.worldToView.T.x;
            output[index++] = view.worldToView.T.y;
            output[index++] = view.worldToView.T.z;
        }
        for (i = 0; i < structure.cameras.length; ++i) {
            SceneStructureMetric.Camera camera = structure.cameras[i];
            if (camera.known) continue;
            camera.model.getIntrinsic(output, index);
            index += camera.model.getIntrinsicCount();
        }
    }
}

