/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.alg.geo.PositiveDepthConstraintCheck;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.se.Se3_F64;
import java.util.List;

public class SelectBestStereoTransform {
    PositiveDepthConstraintCheck depthCheck;

    public SelectBestStereoTransform(Triangulate2ViewsMetric triangulate) {
        this.depthCheck = new PositiveDepthConstraintCheck(triangulate);
    }

    public SelectBestStereoTransform() {
        this(FactoryMultiView.triangulate2ViewMetric(new ConfigTriangulation(ConfigTriangulation.Type.GEOMETRIC)));
    }

    public void select(List<Se3_F64> candidatesAtoB, List<AssociatedPair> observations, Se3_F64 model) {
        Se3_F64 bestModel = null;
        int bestCount = -1;
        for (int i = 0; i < candidatesAtoB.size(); ++i) {
            Se3_F64 s = candidatesAtoB.get(i);
            int count = 0;
            for (AssociatedPair p : observations) {
                if (!this.depthCheck.checkConstraint(p.p1, p.p2, s)) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            bestCount = count;
            bestModel = s;
        }
        if (bestModel == null) {
            throw new RuntimeException("BUG");
        }
        model.set(bestModel);
    }
}

