/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.trifocal.TrifocalLinearPoint7;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ddogleg.optimization.IterativeOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UtilOptimize;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class TrifocalAlgebraicPoint7
extends TrifocalLinearPoint7 {
    private UnconstrainedLeastSquares optimizer;
    private ErrorFunction errorFunction = new ErrorFunction();
    private int maxIterations;
    private double ftol;
    private double gtol;
    private double[] param = new double[6];

    public TrifocalAlgebraicPoint7(UnconstrainedLeastSquares optimizer, int maxIterations, double ftol, double gtol) {
        this.optimizer = optimizer;
        this.maxIterations = maxIterations;
        this.ftol = ftol;
        this.gtol = gtol;
    }

    @Override
    public boolean process(List<AssociatedTriple> observations, TrifocalTensor solution) {
        if (observations.size() < 7) {
            throw new IllegalArgumentException("At least 7 correspondences must be provided");
        }
        LowLevelMultiViewOps.computeNormalization(observations, this.N1, this.N2, this.N3);
        this.createLinearSystem(observations);
        this.solveLinearSystem();
        this.minimizeWithGeometricConstraints();
        this.removeNormalization(solution);
        return true;
    }

    private void minimizeWithGeometricConstraints() {
        this.extractEpipoles.setTensor(this.solutionN);
        this.extractEpipoles.extractEpipoles(this.e2, this.e3);
        this.param[0] = this.e2.x;
        this.param[1] = this.e2.y;
        this.param[2] = this.e2.z;
        this.param[3] = this.e3.x;
        this.param[4] = this.e3.y;
        this.param[5] = this.e3.z;
        this.errorFunction.init();
        this.optimizer.setFunction((FunctionNtoM)this.errorFunction, null);
        this.optimizer.initialize(this.param, this.gtol, this.ftol);
        UtilOptimize.process((IterativeOptimization)this.optimizer, (int)this.maxIterations);
        double[] found = this.optimizer.getParameters();
        TrifocalAlgebraicPoint7.paramToEpipoles(found, this.e2, this.e3);
        this.enforce.process(this.e2, this.e3, this.A);
        this.enforce.extractSolution(this.solutionN);
    }

    private static void paramToEpipoles(double[] found, Point3D_F64 e2, Point3D_F64 e3) {
        e2.x = found[0];
        e2.y = found[1];
        e2.z = found[2];
        e3.x = found[3];
        e3.y = found[4];
        e3.z = found[5];
    }

    private class ErrorFunction
    implements FunctionNtoM {
        Point3D_F64 e2 = new Point3D_F64();
        Point3D_F64 e3 = new Point3D_F64();
        DMatrixRMaj errors = new DMatrixRMaj(1, 1);

        private ErrorFunction() {
        }

        public void init() {
            this.errors.numRows = TrifocalAlgebraicPoint7.this.A.numRows;
            this.errors.numCols = 1;
        }

        public int getNumOfInputsN() {
            return 6;
        }

        public int getNumOfOutputsM() {
            return TrifocalAlgebraicPoint7.this.A.numRows;
        }

        public void process(double[] input, double[] output) {
            TrifocalAlgebraicPoint7.paramToEpipoles(input, this.e2, this.e3);
            TrifocalAlgebraicPoint7.this.enforce.process(this.e2, this.e3, TrifocalAlgebraicPoint7.this.A);
            this.errors.data = output;
            TrifocalAlgebraicPoint7.this.enforce.computeErrorVector(TrifocalAlgebraicPoint7.this.A, this.errors);
        }
    }
}

