/*
 * Decompiled with CFR 0.152.
 */
package com.jimageconnect.directshow;

import com.jimageconnect.core.JImageConnectException;
import com.jimageconnect.core.JImageconnect;
import com.jimageconnect.directshow.DirectShowEvent;
import com.jimageconnect.directshow.DirectShowEventListener;
import com.jimageconnect.util.DllLoader;
import com.twainconnect.core.PropertyManager;
import com.twainconnect.io.imp.BmpMemoryLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class DirectShowConnect
implements JImageconnect {
    private String[] sources;
    private boolean useMemoryForAcquisition = true;
    private String current_source;
    private BufferedImage bufferedImage;
    private static PropertyManager pm = PropertyManager.getInstance();
    private static final Logger LOGGER = Logger.getLogger(DirectShowConnect.class.getPackage().getName());
    private final EventListenerList listenerList = new EventListenerList();
    private DirectShowEvent directShowEvent;

    public DirectShowConnect() {
        this.sources = new String[]{"DirectShow"};
        try {
            DllLoader.initLib();
        }
        catch (Exception e) {
            this.fireDirectShowFailed(new JImageConnectException(e.getMessage()));
            LOGGER.finest(e.getMessage());
        }
    }

    public void acquire(String sourcename) throws JImageConnectException {
        if (this.useMemoryForAcquisition) {
            this.acquireImagesMemory(sourcename);
        }
    }

    public void acquireImagesMemory(String sourcename) throws JImageConnectException {
        this.current_source = sourcename;
        if (this.isDirectShowAvailbable()) {
            do {
                String msg;
                try {
                    Image in = this.acquireNativeMemory(this.current_source);
                    if (in != null) {
                        BmpMemoryLoader loader = new BmpMemoryLoader();
                        this.bufferedImage = loader.load(in);
                        this.fireDirectShowImageCaptured();
                        LOGGER.info("Loaded DirectShow :" + this.current_source);
                        continue;
                    }
                    msg = String.valueOf(pm.getValue("error_image_not_captured")) + " : " + this.current_source;
                    this.fireDirectShowFailed(new JImageConnectException(msg));
                    LOGGER.info(msg);
                }
                catch (Exception e) {
                    msg = String.valueOf(pm.getValue("error_image_not_captured")) + " : " + this.current_source + " : ";
                    msg = String.valueOf(msg) + msg + e.getMessage();
                    this.fireDirectShowFailed(new JImageConnectException(msg));
                    LOGGER.finest(msg);
                }
            } while (this.moreImagesAvailable());
        }
    }

    public boolean moreImagesAvailable() {
        return false;
    }

    protected void fireDirectShowFailed(JImageConnectException exception) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DirectShowEventListener.class) {
                if (this.directShowEvent == null) {
                    this.directShowEvent = new DirectShowEvent(this);
                }
                this.directShowEvent.setBufferedImage(this.bufferedImage);
                this.directShowEvent.setSourceName(this.current_source);
                ((DirectShowEventListener)listeners[i + 1]).direcShowImageCaptured(this.directShowEvent);
            }
            i -= 2;
        }
    }

    protected void fireDirectShowImageCaptured() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == DirectShowEventListener.class) {
                if (this.directShowEvent == null) {
                    this.directShowEvent = new DirectShowEvent(this);
                }
                this.directShowEvent.setBufferedImage(this.bufferedImage);
                this.directShowEvent.setSourceName(this.current_source);
                ((DirectShowEventListener)listeners[i + 1]).direcShowImageCaptured(this.directShowEvent);
            }
            i -= 2;
        }
    }

    public boolean isDirectShowAvailbable() {
        return this.getAvailableSources().length > 0;
    }

    public void addDirectShowListener(DirectShowEventListener listener) {
        this.listenerList.add(DirectShowEventListener.class, listener);
    }

    public String[] getAvailableSources() {
        return this.getAvailableSourcesNative();
    }

    public boolean isEngineAvailble() {
        return this.isDirectShowAvailbable();
    }

    public native Image acquireNativeMemory(String var1) throws JImageConnectException;

    private native String[] getAvailableSourcesNative();
}

