/*
 * Decompiled with CFR 0.152.
 */
package com.jimageconnect.util;

import com.jimageconnect.core.JImageConnectException;
import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.TwainConnect;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class DllLoader {
    private static String DLL_ROOT_NAME;
    private static String msvcp71_DLL_ROOT_NAME;
    private static String msvcr71_DLL_ROOT_NAME;
    private static boolean loaded;
    private static String USR_DIR;
    private static String JAVA_LIB_PATH;
    static final String tc_loader = "tc_loader";
    private static final Logger LOGGER;
    private static final String DLL_LOAD_PROCESS = "dll-name-load-process";
    private static PropertyManager pm;

    static {
        loaded = false;
        LOGGER = Logger.getLogger(TwainConnect.class.getPackage().getName());
        pm = PropertyManager.getInstance();
    }

    private DllLoader() {
    }

    public static synchronized void initLib() throws JImageConnectException {
        if (!loaded) {
            loaded = true;
            DLL_ROOT_NAME = pm.getValue("dll-name");
            msvcp71_DLL_ROOT_NAME = pm.getValue("msvcp71-name");
            msvcr71_DLL_ROOT_NAME = pm.getValue("msvcr71-name");
            USR_DIR = System.getProperty("user.dir");
            JAVA_LIB_PATH = System.getProperty("java.library.path");
            LOGGER.info("System.getProperty 'user.dir' set to : " + USR_DIR);
            LOGGER.info("System.getProperty 'java.library.path' set to : " + JAVA_LIB_PATH);
            String ext = ".dll";
            String FILENAME = String.valueOf(DLL_ROOT_NAME) + ext;
            String msvcp71_FILENAME = String.valueOf(msvcp71_DLL_ROOT_NAME) + ext;
            String msvcr71_FILENAME = String.valueOf(msvcr71_DLL_ROOT_NAME) + ext;
            String FILENAME_WITH_PATH = String.valueOf(USR_DIR) + "\\" + DLL_ROOT_NAME + ext;
            String msvcp71_WITH_PATH = String.valueOf(USR_DIR) + "\\" + msvcp71_DLL_ROOT_NAME + ext;
            String msvcr71_WITH_PATH = String.valueOf(USR_DIR) + "\\" + msvcr71_DLL_ROOT_NAME + ext;
            File file = null;
            try {
                String type = PropertyManager.getInstance().getValue(DLL_LOAD_PROCESS);
                boolean auto_install = type.equalsIgnoreCase("AUTO");
                LOGGER.info("Load process is set to : " + type);
                if (auto_install) {
                    DllLoader.extractFile(FILENAME, FILENAME_WITH_PATH, file);
                    DllLoader.extractFile(msvcp71_FILENAME, msvcp71_WITH_PATH, file);
                    DllLoader.extractFile(msvcr71_FILENAME, msvcr71_WITH_PATH, file);
                }
                System.loadLibrary(DLL_ROOT_NAME);
                LOGGER.info("Debugger Loaded : " + DLL_ROOT_NAME);
            }
            catch (Exception e) {
                LOGGER.finest(String.valueOf(FILENAME) + "Failed with error " + e.getMessage());
                throw new JImageConnectException(e);
            }
        }
    }

    private static void extractFile(String fn, String fn_path, File f) throws IOException, FileNotFoundException {
        LOGGER.info("Attempting to create InputStream : " + fn + " from JAR");
        InputStream is = TwainConnect.class.getResourceAsStream(fn);
        LOGGER.info("InputStream to extract : " + fn + " from JAR created");
        DataInputStream in = new DataInputStream(is);
        LOGGER.info("DataInputStream to extract : " + fn + " from JAR created");
        LOGGER.info("About to create file name : " + fn_path);
        try {
            f = new File(fn_path);
            LOGGER.info("Created FILE Object with : " + fn_path + " as loction");
        }
        catch (Exception e) {
            LOGGER.info("Exception with creating  FILE object" + fn_path);
            LOGGER.info(e.getMessage());
        }
        if (f != null && f.exists()) {
            if (f.delete()) {
                LOGGER.info("file : " + f.getName() + " found and deleted");
                f.createNewFile();
                LOGGER.info("New file " + f.getAbsoluteFile() + " created");
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(fn_path, true));
                byte[] buffer = new byte[1048];
                while (in.available() > 0) {
                    in.read(buffer);
                    dos.write(buffer);
                }
                in.close();
                dos.close();
                LOGGER.info("Wrote DLL to : " + f.getAbsoluteFile());
            } else {
                LOGGER.warning("DLL was not deleted. This may mean there are two instances of the DLL loaded");
            }
        } else {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(fn_path, true));
            LOGGER.info("File DOES NOT EXIST - create DataOutputStream - USUALLY FOR THE FIRST TIME SCENARIO");
            byte[] buffer = new byte[1048];
            while (in.available() > 0) {
                in.read(buffer);
                dos.write(buffer);
            }
            in.close();
            dos.close();
        }
    }

    public String toString() {
        return super.toString();
    }

    private static void createAndShowGUI() {
        try {
            DllLoader.initLib();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DllLoader.createAndShowGUI();
            }
        });
    }
}

