/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.core;

import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.logging.Logger;

public class PropertyManager {
    private static Logger LOGGER = Logger.getLogger(PropertyManager.class.getName());
    private static PropertyManager instance = new PropertyManager();
    private static final String TC_BUNDLE_RESOURCE_NAME_ = "com/twainconnect/twainconnect.properties";

    private PropertyManager() {
    }

    public static PropertyManager getInstance() {
        return instance;
    }

    public String getValue(String resourceName, String key) {
        try {
            InputStream is = PropertyManager.class.getClassLoader().getResourceAsStream(resourceName);
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            String prop = "Error[" + key + "]";
            prop = bundle.getString(key);
            return prop;
        }
        catch (Exception e) {
            LOGGER.finest(e.getMessage());
            return "Error Reading  key [" + key + ']';
        }
    }

    public String getValue(String key) {
        return this.getValue(TC_BUNDLE_RESOURCE_NAME_, key);
    }

    public String getSystemProperty(String key, String defaultValue) {
        boolean isEmpty;
        String o = System.getProperties().getProperty(key, defaultValue);
        boolean bl = isEmpty = o.toString() != null && o.toString().length() > 0;
        if (o == null || key == null || isEmpty) {
            return defaultValue;
        }
        return o.toString();
    }
}

