/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.core;

import com.jimageconnect.core.JImageconnect;
import com.jimageconnect.util.DllLoader;
import com.twainconnect.core.BitDepth;
import com.twainconnect.core.Capability;
import com.twainconnect.core.Dpi;
import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.RegionOfInterest;
import com.twainconnect.core.TwainConnectException;
import com.twainconnect.core.TwainEvent;
import com.twainconnect.core.TwainEventListener;
import com.twainconnect.core.UnitOfMeasure;
import com.twainconnect.io.ImageLoader;
import com.twainconnect.io.imp.BmpMemoryLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class TwainConnect
implements JImageconnect {
    static final String tc_loader = "tc_loader";
    private static String DLL_NAME;
    private static String CUR_DIR;
    private String current_source;
    private boolean useMemoryForAcquisition = true;
    private boolean cancelScanning = false;
    private static final Logger LOGGER;
    private static final String error_capability_not_set = "error_capability_not_set";
    private static final int TWAIN_BW = 0;
    private static final int TWAIN_GRAY = 1;
    private static final int TWAIN_RGB = 2;
    private static final String DLL_LOAD_PROCESS = "dll-name-load-process";
    private static PropertyManager pm;
    private final EventListenerList listenerList = new EventListenerList();
    private TwainEvent twainEvent;
    private BufferedImage bufferedImage;
    private String img_io_class_name;
    private ImageLoader imgLdr;

    static {
        LOGGER = Logger.getLogger(TwainConnect.class.getPackage().getName());
        pm = PropertyManager.getInstance();
    }

    public TwainConnect() throws TwainConnectException {
        DLL_NAME = pm.getValue("dll-name");
        CUR_DIR = System.getProperty("user.dir");
        this.img_io_class_name = pm.getValue(tc_loader);
        try {
            DllLoader.initLib();
        }
        catch (Exception e) {
            this.fireTwainImageFailed(e);
            LOGGER.finest(e.getMessage());
        }
    }

    public void addTwainListener(TwainEventListener l) {
        this.listenerList.add(TwainEventListener.class, l);
    }

    public void removeTwainListener(TwainEventListener l) {
        this.listenerList.remove(TwainEventListener.class, l);
    }

    protected void fireTwainImageCaptured() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TwainEventListener.class) {
                if (this.twainEvent == null) {
                    this.twainEvent = new TwainEvent(this);
                }
                this.twainEvent.setBufferedImage(this.bufferedImage);
                this.twainEvent.setSourceName(this.current_source);
                ((TwainEventListener)listeners[i + 1]).twainImageCaptured(this.twainEvent);
            }
            i -= 2;
        }
    }

    protected void fireTwainImageFailed(Exception e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TwainEventListener.class) {
                if (this.twainEvent == null) {
                    this.twainEvent = new TwainEvent(this);
                }
                this.twainEvent.setBufferedImage(new BufferedImage(1, 1, 1));
                this.twainEvent.setSourceName(this.current_source);
                this.twainEvent.setException(e);
                ((TwainEventListener)listeners[i + 1]).twainImageCapturedFailed(this.twainEvent);
            }
            i -= 2;
        }
    }

    protected void fireTwainCapabilityNotSet(Capability c) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TwainEventListener.class) {
                if (this.twainEvent == null) {
                    this.twainEvent = new TwainEvent(this);
                }
                this.twainEvent.setBufferedImage(new BufferedImage(1, 1, 1));
                this.twainEvent.setSourceName(this.current_source);
                this.twainEvent.setException(new TwainConnectException("Failed to set " + (Object)((Object)c)));
                ((TwainEventListener)listeners[i + 1]).twainCapabilityNotSet(this.twainEvent);
            }
            i -= 2;
        }
    }

    protected void fireTwainCapabilitySet(Capability c) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TwainEventListener.class) {
                if (this.twainEvent == null) {
                    this.twainEvent = new TwainEvent(this);
                }
                this.twainEvent.setBufferedImage(new BufferedImage(1, 1, 1));
                this.twainEvent.setSourceName(this.current_source);
                this.twainEvent.setCapability(c);
                ((TwainEventListener)listeners[i + 1]).twainCapabilitySet(this.twainEvent);
            }
            i -= 2;
        }
    }

    public String getClassLoaderName() {
        return this.img_io_class_name;
    }

    public void setClassLoaderName(String classLoaderName) {
        this.img_io_class_name = classLoaderName;
    }

    public boolean isTwainAvailble() {
        return this.isTwainAvailbleNative();
    }

    public boolean isUseMemoryForAcquisition() {
        return this.useMemoryForAcquisition;
    }

    public void setUseMemoryForAcquisition(boolean useMemoryForAcquisition) {
        this.useMemoryForAcquisition = useMemoryForAcquisition;
    }

    public boolean isCancelScanning() {
        return this.cancelScanning;
    }

    public void setCancelScanning(boolean cancelScanning) {
        this.cancelScanning = cancelScanning;
    }

    public String[] getAvailableSources() {
        String[] array = null;
        if (this.isTwainAvailble()) {
            array = this.getAvailableSourcesNative();
            if (array == null || array.length == 0) {
                String msg = pm.getValue("no_sources");
                array = new String[]{msg};
            }
        } else {
            array = new String[]{"Twain Error"};
        }
        return array;
    }

    protected ImageLoader getLoader() throws TwainConnectException {
        if (this.imgLdr == null) {
            String className = this.getClassLoaderName();
            if (className != null && className.length() > 0) {
                try {
                    Class<?> clazz = Class.forName(className);
                    this.imgLdr = (ImageLoader)clazz.newInstance();
                }
                catch (Exception e) {
                    LOGGER.finest(e.getMessage());
                    String n = "Could no load class " + className + " " + e.getMessage();
                    throw new TwainConnectException(n);
                }
            } else {
                String msg = "Could not ImageLoader class property";
                LOGGER.finest(msg);
                throw new TwainConnectException(msg);
            }
        }
        return this.imgLdr;
    }

    public void acquire(String sourcename) throws TwainConnectException {
        this.cancelScanning = false;
        if (this.useMemoryForAcquisition) {
            this.acquireImagesMemory(sourcename);
        } else {
            this.acquireImagesFileIo(sourcename);
        }
    }

    public void acquireImagesMemory(String sourcename) throws TwainConnectException {
        this.current_source = sourcename;
        if (this.isTwainAvailble()) {
            do {
                String msg;
                try {
                    Image in = TwainConnect.acquireNativeMemory(this.current_source);
                    if (in != null) {
                        BmpMemoryLoader loader = new BmpMemoryLoader();
                        this.bufferedImage = loader.load(in);
                        this.fireTwainImageCaptured();
                        continue;
                    }
                    msg = String.valueOf(pm.getValue("error_image_not_captured")) + " : " + this.current_source;
                    this.fireTwainImageFailed(new TwainConnectException(msg));
                    LOGGER.finest(msg);
                }
                catch (Exception e) {
                    msg = String.valueOf(pm.getValue("error_image_not_captured")) + " : " + this.current_source + " : ";
                    msg = String.valueOf(msg) + msg + e.getMessage();
                    this.fireTwainImageFailed(new TwainConnectException(msg));
                    LOGGER.finest(msg);
                }
            } while (this.moreImagesAvailable() && !this.cancelScanning);
        }
    }

    public void acquireImagesFileIo(String sourcename) throws TwainConnectException {
        this.current_source = sourcename;
        if (this.isTwainAvailble()) {
            do {
                boolean validFileName;
                String _filename = this.acquireNative(this.current_source);
                LOGGER.fine("Opening : " + _filename);
                boolean bl = validFileName = _filename != null && _filename.length() > 0;
                if (validFileName) {
                    try {
                        ImageLoader il = this.getLoader();
                        LOGGER.fine("Created ImageLoader Class " + il);
                        File file = new File(_filename);
                        this.bufferedImage = il.load(file);
                        this.fireTwainImageCaptured();
                    }
                    catch (Exception e) {
                        String msg = String.valueOf(PropertyManager.getInstance().getValue("error.imageloader-not-created")) + " : " + this.current_source;
                        this.fireTwainImageFailed(new TwainConnectException(msg));
                        LOGGER.finest(msg);
                    }
                    continue;
                }
                String msg = String.valueOf(PropertyManager.getInstance().getValue(error_capability_not_set)) + " for source : " + this.current_source;
                this.fireTwainImageFailed(new TwainConnectException(msg));
                LOGGER.finest(msg);
            } while (this.moreImagesAvailable() && !this.cancelScanning);
        }
    }

    public void showUi(boolean show) {
        if (this.isTwainAvailble()) {
            LOGGER.fine("Enable the Vendor UI : " + show);
            this.showUiNative(show);
        }
    }

    public boolean openSource(String sourcename) {
        LOGGER.fine("Open Source : " + sourcename);
        this.current_source = sourcename;
        return this.openSourceNative(this.current_source);
    }

    public boolean setDeviceXResolution(Dpi resolution) {
        return this.setDeviceXResolution(Integer.valueOf(resolution.toString()));
    }

    public boolean setDeviceYResolution(Dpi resolution) {
        return this.setDeviceYResolution(Integer.valueOf(resolution.toString()));
    }

    public boolean setDeviceXResolution(int resolution) {
        LOGGER.fine("setDeviceXResolution : " + resolution);
        boolean result = this.setDeviceXResolutionNative(resolution);
        if (!result) {
            this.fireTwainCapabilityNotSet(Capability.ICAP_XRESOLUTION);
        } else {
            this.fireTwainCapabilitySet(Capability.ICAP_XRESOLUTION);
        }
        return result;
    }

    public boolean setDeviceYResolution(int resolution) {
        LOGGER.fine("setDeviceXResolution : " + resolution);
        boolean result = this.setDeviceYResolutionNative(resolution);
        if (!result) {
            this.fireTwainCapabilityNotSet(Capability.ICAP_YRESOLUTION);
        } else {
            this.fireTwainCapabilitySet(Capability.ICAP_XRESOLUTION);
        }
        return result;
    }

    public boolean setDeviceXScale(short percent) throws UnsupportedOperationException {
        LOGGER.fine("setDeviceXScale : " + percent);
        if (percent < 1) {
            percent = 1;
        } else if (percent > 100) {
            percent = (short)100;
        }
        boolean result = this.setDeviceXScaleNative(percent);
        if (!result) {
            this.fireTwainCapabilityNotSet(Capability.ICAP_XSCALING);
        } else {
            this.fireTwainCapabilitySet(Capability.ICAP_XSCALING);
        }
        return result;
    }

    public boolean setDeviceYScale(short percent) {
        LOGGER.fine("setDeviceYScale : " + percent);
        if (percent < 1) {
            percent = 1;
        } else if (percent > 100) {
            percent = (short)100;
        }
        boolean result = this.setDeviceYScaleNative(percent);
        if (!result) {
            this.fireTwainCapabilityNotSet(Capability.ICAP_YSCALING);
        } else {
            this.fireTwainCapabilitySet(Capability.ICAP_YSCALING);
        }
        return result;
    }

    public boolean closeSource(String sourcename) {
        LOGGER.fine("closeSource : " + sourcename);
        return this.closeSourceNative(sourcename);
    }

    public void setBitDepth(BitDepth bitDepth) {
        if (this.isTwainAvailble()) {
            LOGGER.finest("setBitDepth : " + (Object)((Object)bitDepth));
            boolean result = false;
            if (bitDepth == BitDepth.bw) {
                result = this.setBitDepthNative(0);
            } else if (bitDepth == BitDepth.gray) {
                result = this.setBitDepthNative(1);
            } else if (bitDepth == BitDepth.color) {
                result = this.setBitDepthNative(2);
            }
            if (!result) {
                this.fireTwainCapabilityNotSet(Capability.ICAP_PIXELTYPE);
            } else {
                this.fireTwainCapabilitySet(Capability.ICAP_PIXELTYPE);
            }
        }
    }

    public boolean setRegionOfInterest(RegionOfInterest roi) {
        boolean useRoi;
        boolean result = false;
        boolean bl = useRoi = roi != null;
        if (this.isTwainAvailble() && useRoi) {
            LOGGER.fine("Set Frame top : " + roi.getTop() + " left : " + roi.getLeft());
            LOGGER.fine("Set Frame bottom : " + roi.getBottom() + " right : " + roi.getRight());
            Capability c = Capability.ICAP_UNITS;
            result = roi.getUom() == UnitOfMeasure.inches ? this.setImageInchesNative(roi.getTop(), roi.getLeft(), roi.getBottom(), roi.getRight()) : (roi.getUom() == UnitOfMeasure.pixels ? this.setImagePixelsNative((int)roi.getTop(), (int)roi.getLeft(), (int)roi.getBottom(), (int)roi.getRight()) : this.setImageCentimetersNative((int)roi.getTop(), (int)roi.getLeft(), (int)roi.getBottom(), (int)roi.getRight()));
            if (!result) {
                this.fireTwainCapabilityNotSet(c);
            } else {
                this.fireTwainCapabilitySet(c);
            }
        }
        return result;
    }

    public boolean isEngineAvailble() {
        return this.isTwainAvailble();
    }

    private native boolean openSourceNative(String var1);

    private native String acquireNative(String var1);

    public static native Image acquireNativeMemory(String var0) throws TwainConnectException;

    public native boolean moreImagesAvailable();

    private native boolean isTwainAvailbleNative();

    private native String[] getAvailableSourcesNative();

    private native void showUiNative(boolean var1);

    private native boolean setImageInchesNative(float var1, float var2, float var3, float var4);

    private native boolean setImageCentimetersNative(float var1, float var2, float var3, float var4);

    private native boolean setImagePixelsNative(int var1, int var2, int var3, int var4);

    private native boolean setDeviceXResolutionNative(int var1);

    private native boolean setDeviceYResolutionNative(int var1);

    private native boolean setDeviceXScaleNative(int var1);

    private native boolean setDeviceYScaleNative(int var1);

    private native boolean setBitDepthNative(int var1);

    private native boolean closeSourceNative(String var1);
}

