/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.io.imp;

import com.twainconnect.core.TwainConnectException;
import com.twainconnect.io.ImageLoader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class TwainConnectImageLoaderImp
implements ImageLoader {
    private static Logger LOGGER = Logger.getLogger(TwainConnectImageLoaderImp.class.getName());
    private static final int ZERO = 255;

    public BufferedImage load(Object o) throws TwainConnectException {
        File file = (File)o;
        if (file == null || !file.exists()) {
            throw new TwainConnectException("File not created for file : " + file);
        }
        try {
            BufferedImage img = this.readBmp(new FileInputStream(file));
            return img;
        }
        catch (Exception e) {
            LOGGER.finest(e.getMessage());
            throw new TwainConnectException(e.getMessage());
        }
    }

    private BufferedImage readBmp(FileInputStream fs) throws IOException {
        BufferedImage img = null;
        BitmapHeader bh = new BitmapHeader();
        bh.read(fs);
        if (bh.nbitcount == 24) {
            img = TwainConnectImageLoaderImp.readMap24(fs, bh);
        } else if (bh.nbitcount == 32) {
            img = TwainConnectImageLoaderImp.readMap32(fs, bh);
        } else if (bh.nbitcount == 8) {
            img = TwainConnectImageLoaderImp.readMap8(fs, bh);
        }
        fs.close();
        return img;
    }

    private static int constructInt(byte[] in, int offset) {
        int ret = in[offset + 3] & 0xFF;
        ret = ret << 8 | in[offset + 2] & 0xFF;
        ret = ret << 8 | in[offset + 1] & 0xFF;
        ret = ret << 8 | in[offset + 0] & 0xFF;
        return ret;
    }

    private static int constructInt3(byte[] in, int offset) {
        int ret = 255;
        ret = ret << 8 | in[offset + 2] & 0xFF;
        ret = ret << 8 | in[offset + 1] & 0xFF;
        ret = ret << 8 | in[offset + 0] & 0xFF;
        return ret;
    }

    private static short constructShort(byte[] in, int offset) {
        short ret = (short)(in[offset + 1] & 0xFF);
        ret = (short)(ret << 8 | (short)(in[offset + 0] & 0xFF));
        return ret;
    }

    private static BufferedImage readMap32(FileInputStream fs, BitmapHeader bh) throws IOException {
        int[] ndata = new int[bh.nheight * bh.nwidth];
        byte[] brgb = new byte[bh.nwidth * 4 * bh.nheight];
        fs.read(brgb, 0, bh.nwidth * 4 * bh.nheight);
        int nindex = 0;
        int j = 0;
        while (j < bh.nheight) {
            int i = 0;
            while (i < bh.nwidth) {
                ndata[bh.nwidth * (bh.nheight - j - 1) + i] = TwainConnectImageLoaderImp.constructInt3(brgb, nindex);
                nindex += 4;
                ++i;
            }
            ++j;
        }
        BufferedImage image = new BufferedImage(bh.nwidth, bh.nheight, 1);
        image.setRGB(0, 0, bh.nwidth, bh.nheight, ndata, 0, bh.nwidth);
        fs.close();
        return image;
    }

    private static BufferedImage readMap24(FileInputStream fs, BitmapHeader bh) throws IOException {
        int npad = bh.nsizeimage / bh.nheight - bh.nwidth * 3;
        int[] ndata = new int[bh.nheight * bh.nwidth];
        byte[] brgb = new byte[(bh.nwidth + npad) * 3 * bh.nheight];
        fs.read(brgb, 0, (bh.nwidth + npad) * 3 * bh.nheight);
        int nindex = 0;
        int j = 0;
        while (j < bh.nheight) {
            int i = 0;
            while (i < bh.nwidth) {
                ndata[bh.nwidth * (bh.nheight - j - 1) + i] = TwainConnectImageLoaderImp.constructInt3(brgb, nindex);
                nindex += 3;
                ++i;
            }
            nindex += npad;
            ++j;
        }
        BufferedImage image = new BufferedImage(bh.nwidth, bh.nheight, 1);
        image.setRGB(0, 0, bh.nwidth, bh.nheight, ndata, 0, bh.nwidth);
        fs.close();
        return image;
    }

    private static BufferedImage readMap8(FileInputStream fs, BitmapHeader bh) throws IOException {
        int nNumColors = 0;
        nNumColors = bh.nclrused > 0 ? bh.nclrused : 1 << bh.nbitcount;
        if (bh.nsizeimage == 0) {
            bh.nsizeimage = (bh.nwidth * bh.nbitcount + 31 & 0xFFFFFFE0) >> 3;
            bh.nsizeimage *= bh.nheight;
        }
        int[] npalette = new int[nNumColors];
        byte[] bpalette = new byte[nNumColors * 4];
        fs.read(bpalette, 0, nNumColors * 4);
        int nindex8 = 0;
        int n = 0;
        while (n < nNumColors) {
            npalette[n] = TwainConnectImageLoaderImp.constructInt3(bpalette, nindex8);
            nindex8 += 4;
            ++n;
        }
        int npad8 = bh.nsizeimage / bh.nheight - bh.nwidth;
        int[] ndata8 = new int[bh.nwidth * bh.nheight];
        byte[] bdata = new byte[(bh.nwidth + npad8) * bh.nheight];
        fs.read(bdata, 0, (bh.nwidth + npad8) * bh.nheight);
        nindex8 = 0;
        int j8 = 0;
        while (j8 < bh.nheight) {
            int i8 = 0;
            while (i8 < bh.nwidth) {
                ndata8[bh.nwidth * (bh.nheight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                ++nindex8;
                ++i8;
            }
            nindex8 += npad8;
            ++j8;
        }
        BufferedImage image = new BufferedImage(bh.nwidth, bh.nheight, 1);
        image.setRGB(0, 0, bh.nwidth, bh.nheight, ndata8, 0, bh.nwidth);
        return image;
    }

    static class BitmapHeader {
        public int nsize;
        public int nbisize;
        public int nwidth;
        public int nheight;
        public int nplanes;
        public int nbitcount;
        public int ncompression;
        public int nsizeimage;
        public int nxpm;
        public int nypm;
        public int nclrused;
        public int nclrimp;

        BitmapHeader() {
        }

        public void read(FileInputStream fs) throws IOException {
            int bflen = 14;
            byte[] bf = new byte[14];
            fs.read(bf, 0, 14);
            int bilen = 40;
            byte[] bi = new byte[40];
            fs.read(bi, 0, 40);
            this.nsize = TwainConnectImageLoaderImp.constructInt(bf, 2);
            this.nbisize = TwainConnectImageLoaderImp.constructInt(bi, 2);
            this.nwidth = TwainConnectImageLoaderImp.constructInt(bi, 4);
            this.nheight = TwainConnectImageLoaderImp.constructInt(bi, 8);
            this.nplanes = TwainConnectImageLoaderImp.constructShort(bi, 12);
            this.nbitcount = TwainConnectImageLoaderImp.constructShort(bi, 14);
            this.ncompression = TwainConnectImageLoaderImp.constructInt(bi, 16);
            this.nsizeimage = TwainConnectImageLoaderImp.constructInt(bi, 20);
            this.nxpm = TwainConnectImageLoaderImp.constructInt(bi, 24);
            this.nypm = TwainConnectImageLoaderImp.constructInt(bi, 28);
            this.nclrused = TwainConnectImageLoaderImp.constructInt(bi, 32);
            this.nclrimp = TwainConnectImageLoaderImp.constructInt(bi, 36);
        }
    }
}

