/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiUtils {
    public static final String IMAGES = "/images/";
    private static Logger LOGGER = Logger.getLogger(UiUtils.class.getPackage().getName());
    private static final Font METRIC_FONT = new Font("SansSerif", 0, 11);
    public static final BufferedImage BLANK = new BufferedImage(200, 200, 1);
    public static final Color ORANGE = new Color(230, 163, 4);

    private UiUtils() {
    }

    public static ImageIcon getIconFromResource(String root, String ext, Class<?> clazz) {
        ImageIcon result = null;
        String imgLocation = IMAGES + root + "." + ext;
        URL imageURL = clazz.getResource(imgLocation);
        if (imageURL != null) {
            result = new ImageIcon(imageURL, root);
        } else {
            LOGGER.finest("Resource not found: " + imgLocation);
        }
        return result;
    }

    public static ImageIcon getIconFromResource(String filename, Class<?> clazz) {
        ImageIcon result = null;
        String imgLocation = IMAGES + filename;
        URL imageURL = clazz.getResource(imgLocation);
        if (imageURL != null) {
            result = new ImageIcon(imageURL, filename);
        } else {
            LOGGER.finest("Resource not found: " + imgLocation);
        }
        return result;
    }

    public static BufferedImage getImageFromResource(String root, Class<?> clazz) {
        BufferedImage bi = null;
        String imgLocation = IMAGES + root;
        URL imageURL = clazz.getResource(imgLocation);
        if (imageURL != null) {
            try {
                bi = ImageIO.read(imageURL);
            }
            catch (IOException ioe) {
                LOGGER.finest(ioe.getMessage());
            }
        } else {
            LOGGER.finest("Resource not found: " + imgLocation);
        }
        return bi;
    }

    public static Font getMetricFont() {
        return METRIC_FONT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

