/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.dialogs;

import com.twainconnect.ui.dialogs.ImageExtensionFileFilter;
import com.twainconnect.ui.dialogs.PreviewPane;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class ApacheImageDialog
extends JFileChooser {
    private static Logger LOGGER = Logger.getLogger(ApacheImageDialog.class.getName());
    private static final String PACK_BITS = "PackBits";
    private static final String IMAGES_PREF = "image/";
    private static final String TIFF_EXT = "tiff";
    private static final String JPG_EXT = "jpeg";
    private static final String PNG_EXT = "png";
    private PreviewPane previewPane;
    private BufferedImage bi;
    private static final long serialVersionUID = 8804495588280792882L;

    public ApacheImageDialog(BufferedImage bi) {
        this.bi = bi;
        this.previewPane = new PreviewPane(bi);
        this.setAccessory(this.previewPane);
        this.addPropertyChangeListener(this.previewPane);
        this.setupWriterFormats();
    }

    private void setupWriterFormats() {
        ImageWriter writer = null;
        writer = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        ImageExtensionFileFilter png = new ImageExtensionFileFilter(false, writer);
        png.addExtension(PNG_EXT, true);
        png.setDescription("png (*.png");
        this.setFileFilter(png);
        writer = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
        ImageExtensionFileFilter jpg = new ImageExtensionFileFilter(false, writer);
        jpg.addExtension("jpg", true);
        jpg.addExtension(JPG_EXT, true);
        jpg.setDescription("jpg (*.jpg,*.jpeg)");
        this.setFileFilter(jpg);
        writer = ImageWriterRegistry.getInstance().getWriterFor("image/tiff");
        ImageExtensionFileFilter tiff = new ImageExtensionFileFilter(false, writer);
        tiff.addExtension("tif", true);
        tiff.addExtension(TIFF_EXT, true);
        tiff.setDescription("tifs (*.tiff, *.tif)");
        this.setFileFilter(tiff);
        this.setAcceptAllFileFilterUsed(false);
        this.setFileSelectionMode(0);
        this.setDialogType(1);
        this.setApproveButtonToolTipText("Export Image to desired format");
        this.setApproveButtonText("Export");
        String ext = ((ImageExtensionFileFilter)this.getFileFilter()).getImageWriterExt();
        String filename = String.valueOf(System.getProperty("user.dir")) + "\\" + "exported_file." + ext;
        this.setSelectedFile(new File(filename));
    }

    public void export(Component parent) {
        int ret = this.showSaveDialog(parent);
        if (ret == 0) {
            try {
                File file = this.getSelectedFile();
                ImageExtensionFileFilter eff = (ImageExtensionFileFilter)this.getFileFilter();
                String updatedfilename = this.updateFileSuffix(file, eff.getImageWriterExt());
                File updatedFile = new File(updatedfilename);
                this.setSelectedFile(updatedFile);
                FileOutputStream fout = new FileOutputStream(file);
                try {
                    ImageWriter writer = eff.getImageWriter();
                    ImageWriterParams params = new ImageWriterParams();
                    params.setResolution(72);
                    if (writer.supportsMultiImageWriter()) {
                        params.setCompressionMethod(PACK_BITS);
                        MultiImageWriter multiWriter = writer.createMultiImageWriter((OutputStream)fout);
                        multiWriter.writeImage((RenderedImage)this.bi, params);
                        multiWriter.close();
                    } else {
                        writer.writeImage((RenderedImage)this.bi, (OutputStream)fout, params);
                    }
                }
                finally {
                    try {
                        fout.close();
                    }
                    catch (Exception exception) {}
                }
                LOGGER.finest("Wrote " + file);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    private String updateFileSuffix(File file, String suffix) {
        String filename = null;
        if (file != null) {
            boolean hasExt;
            filename = file.getPath();
            int lp = filename.lastIndexOf(".");
            int len = filename.length();
            boolean bl = hasExt = len - 4 == lp;
            if (!hasExt) {
                filename = String.valueOf(filename) + "." + suffix;
            }
        }
        return filename;
    }

    private static void createAndShowGUI() {
        try {
            BufferedImage bi = new BufferedImage(100, 100, 1);
            ApacheImageDialog dlg = new ApacheImageDialog(bi);
            dlg.export(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ApacheImageDialog.createAndShowGUI();
            }
        });
    }
}

