/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.dialogs;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import org.apache.xmlgraphics.image.writer.ImageWriter;

public class ImageExtensionFileFilter
extends FileFilter {
    private static Logger LOGGER = Logger.getLogger(ImageExtensionFileFilter.class.getName());
    public static final String TIFF_EXT = "tiff";
    public static final String JPG_EXT = "jpeg";
    public static final String PNG_EXT = "png";
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private String description;
    private boolean allowDirectories;
    private Hashtable<String, Boolean> extensionsTable = new Hashtable();
    private boolean allowAll = false;
    private ImageWriter imageWriter;

    public ImageExtensionFileFilter(boolean allowDirectories, ImageWriter imageWriter) {
        this.allowDirectories = allowDirectories;
        this.imageWriter = imageWriter;
    }

    public ImageWriter getImageWriter() {
        return this.imageWriter;
    }

    public String getImageWriterExt() {
        String ext = "";
        try {
            String mimeType = this.imageWriter.getMIMEType();
            int sp = mimeType.lastIndexOf("/");
            ext = mimeType.substring(sp + 1);
        }
        catch (Exception e) {
            LOGGER.fine(e.getMessage());
        }
        return ext;
    }

    public void setImageWriter(ImageWriter imageWriter) {
        this.imageWriter = imageWriter;
    }

    public void addExtension(String extension, boolean caseInsensitive) {
        if (caseInsensitive) {
            extension = extension.toLowerCase();
        }
        if (!this.extensionsTable.containsKey(extension)) {
            this.extensionsTable.put(extension, new Boolean(caseInsensitive));
            if (extension.equals("*") || extension.equals("*.*") || extension.equals(".*")) {
                this.allowAll = true;
            }
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.allowDirectories;
        }
        if (this.allowAll) {
            return true;
        }
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == name.length() - 1) {
            return false;
        }
        String extension = name.substring(dotIndex + 1);
        if (this.extensionsTable.containsKey(extension)) {
            return true;
        }
        Enumeration<String> keys = this.extensionsTable.keys();
        while (keys.hasMoreElements()) {
            String possibleExtension = keys.nextElement();
            Boolean caseFlag = this.extensionsTable.get(possibleExtension);
            if (caseFlag == null || !caseFlag.equals(Boolean.FALSE) || !possibleExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

