/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.dialogs;

import com.twainconnect.image.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PreviewPane
extends JPanel
implements PropertyChangeListener {
    private static Logger LOGGER = Logger.getLogger(PreviewPane.class.getName());
    private static final long serialVersionUID = 7525453280757692953L;
    private PreviewPaneData data = new PreviewPaneData();
    private static int previewWindowHt = 200;
    private static int previewWindowWidth = 200;

    public PreviewPane() {
        this((BufferedImage)null);
    }

    public PreviewPane(BufferedImage bi) {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)new JLabel("Preview:"), "North");
        this.data.maxImgWidth = 195;
        this.data.label.setBackground(Color.WHITE);
        this.data.label.setOpaque(true);
        this.data.label.setPreferredSize(new Dimension(previewWindowWidth, previewWindowHt));
        if (bi != null) {
            ImageIcon ic = ImageUtils.getScaledIcon(bi, previewWindowWidth, previewWindowHt);
            this.data.label.setIcon(ic);
        }
        this.data.label.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.data.label, "Center");
    }

    private boolean vadlidImage(String path) {
        return path.endsWith(".gif") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png") || path.endsWith(".tif") || path.endsWith(".tiff") || path.endsWith(".png") || path.endsWith(".bmp");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String path;
        boolean vadlidImage;
        File newFile;
        ImageIcon icon = null;
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName()) && (newFile = (File)evt.getNewValue()) != null && (vadlidImage = this.vadlidImage(path = newFile.getAbsolutePath()))) {
            try {
                BufferedImage img = ImageIO.read(newFile);
                if (img != null) {
                    float width = img.getWidth();
                    float height = img.getHeight();
                    float scale = height / width;
                    width = this.data.maxImgWidth;
                    height = width * scale;
                    icon = new ImageIcon(img.getScaledInstance(Math.max(1, (int)width), Math.max(1, (int)height), 4));
                    this.data.label.setIcon(icon);
                    this.repaint();
                } else {
                    LOGGER.finest("newFile " + newFile + " is not valid");
                }
            }
            catch (IOException e) {
                LOGGER.finest("newFile " + newFile + " is not valid");
            }
        }
    }

    public void setBufferedImage(BufferedImage img) {
        if (img != null) {
            float width = img.getWidth();
            float height = img.getHeight();
            float scale = height / width;
            width = this.data.maxImgWidth;
            height = width * scale;
            ImageIcon icon = new ImageIcon(img.getScaledInstance(Math.max(1, (int)width), Math.max(1, (int)height), 4));
            this.data.label.setIcon(icon);
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        try {
            BufferedImage bi = new BufferedImage(100, 100, 1);
            PreviewPane panel = new PreviewPane(bi);
            frame.setContentPane(panel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame.pack();
        frame.setSize(600, 480);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PreviewPane.createAndShowGUI();
            }
        });
    }

    static class PreviewPaneData {
        public JLabel label = new JLabel();
        public int maxImgWidth;
    }
}

