/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.imagepanel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;

public class CentredBackgroundBorder
implements Border {
    private final BufferedImage image;
    private Insets ZERO = new Insets(0, 0, 0, 0);

    public CentredBackgroundBorder(BufferedImage image) {
        this.image = image;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int x0 = x + (width - this.image.getWidth()) / 2;
        int y0 = y + (height - this.image.getHeight()) / 2;
        AffineTransform tx = AffineTransform.getTranslateInstance(x0, y0);
        ((Graphics2D)g).drawRenderedImage(this.image, tx);
    }

    public Insets getBorderInsets(Component c) {
        return this.ZERO;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

