/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.imagepanel;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.UnitOfMeasure;
import com.twainconnect.image.ImageUtils;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.imagepanel.Corner;
import com.twainconnect.ui.imagepanel.CroppingScrollPane;
import com.twainconnect.ui.imagepanel.Ruler;
import com.twainconnect.ui.imagepanel.ScrollablePicture;
import com.twainconnect.ui.widgets.AcquiredImage;
import com.twainconnect.ui.widgets.UnitOfMeasureComp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ImageScrollPanel
extends JPanel
implements ListDataListener {
    private static Logger LOGGER = Logger.getLogger(ImageScrollPanel.class.getName());
    private static final long serialVersionUID = 5820746780001282679L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private Ruler columnView;
    private Ruler rowView;
    private UnitOfMeasureComp uomComp;
    private ScrollablePicture picture;
    private CroppingScrollPane pictureScrollPane;
    private DefaultListModel model;
    private int selectedModelImage;

    public ImageScrollPanel(DefaultListModel model) {
        this.model = model;
        model.addListDataListener(this);
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 2));
        this.selectedModelImage = 0;
        this.createImagePanel();
    }

    private void createImagePanel() {
        this.columnView = new Ruler(UiUtils.Orientation.HORIZONTAL, UnitOfMeasure.inches);
        this.rowView = new Ruler(UiUtils.Orientation.VERTICAL, UnitOfMeasure.inches);
        this.columnView.setPreferredWidth(UiUtils.BLANK.getWidth());
        this.rowView.setPreferredHeight(UiUtils.BLANK.getHeight());
        JPanel buttonCorner = new JPanel();
        this.uomComp = new UnitOfMeasureComp();
        this.uomComp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnitOfMeasureComp c = (UnitOfMeasureComp)e.getSource();
                ImageScrollPanel.this.setUnitOfMeasure(c.getUnitOfMeasure());
                ImageScrollPanel.this.picture.setMaxUnitIncrement(ImageScrollPanel.this.rowView.getIncrement());
            }
        });
        this.uomComp.setPreferredSize(new Dimension(40, 25));
        buttonCorner.add(this.uomComp);
        String name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_twacker");
        BufferedImage ico = UiUtils.getImageFromResource(name, this.getClass());
        this.picture = ico != null ? new ScrollablePicture(ico, 1) : new ScrollablePicture(UiUtils.BLANK, 1);
        this.pictureScrollPane = new CroppingScrollPane(this.picture);
        this.pictureScrollPane.setPreferredSize(new Dimension(300, 250));
        this.pictureScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.blue));
        this.pictureScrollPane.setColumnHeaderView(this.columnView);
        this.pictureScrollPane.setRowHeaderView(this.rowView);
        this.pictureScrollPane.setCorner("UPPER_LEADING_CORNER", buttonCorner);
        this.pictureScrollPane.setCorner("LOWER_LEADING_CORNER", new Corner());
        this.pictureScrollPane.setCorner("UPPER_TRAILING_CORNER", new Corner());
        this.add(this.pictureScrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void setUnitOfMeasure(UnitOfMeasure uom) {
        this.rowView.setUnitOfMeasure(uom);
        this.columnView.setUnitOfMeasure(uom);
        this.uomComp.setUnitOfMeasure(uom);
    }

    protected void setBufferedImage(BufferedImage bi) {
        ImageIcon imgIcon = null;
        if (bi == null) {
            imgIcon = new ImageIcon(UiUtils.BLANK);
        } else {
            this.columnView.setPreferredWidth(bi.getWidth());
            this.rowView.setPreferredHeight(bi.getHeight());
            bi.flush();
            imgIcon = new ImageIcon();
            imgIcon.setImage(bi);
        }
        this.picture.setIcon(imgIcon);
    }

    public BufferedImage getBufferedImage() {
        ImageIcon im = (ImageIcon)this.picture.getIcon();
        return ImageUtils.toBufferedImage(im);
    }

    public ScrollablePicture getPicture() {
        return this.picture;
    }

    public void cropSelf() {
        this.picture.cropSelf();
    }

    public void contentsChanged(ListDataEvent e) {
        Object o = e.getSource();
        AcquiredImage ai = null;
        int size = this.model.getSize();
        if (o instanceof JList) {
            JList list = (JList)o;
            this.selectedModelImage = list.getSelectedIndex();
            LOGGER.info("JList selectedItem [" + this.selectedModelImage + "].");
            LOGGER.info("Model size [" + size + "].");
            if (size == 1) {
                ai = (AcquiredImage)this.model.getElementAt(0);
                this.setBufferedImage(ai.getImage());
            } else if (this.selectedModelImage < size) {
                ai = (AcquiredImage)this.model.getElementAt(this.selectedModelImage);
                this.setBufferedImage(ai.getImage());
            } else {
                LOGGER.info("JList selectedItem [" + this.selectedModelImage + "].");
            }
        } else if (o instanceof DefaultListModel) {
            if (this.selectedModelImage > -1 && this.selectedModelImage < size) {
                ai = (AcquiredImage)this.model.getElementAt(this.selectedModelImage);
                this.setBufferedImage(ai.getImage());
            }
        } else {
            LOGGER.warning("Source is not a JList. Instead we have a [" + e.getSource().getClass().getName() + "].");
        }
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
        this.picture.setIcon(null);
    }
}

