/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.imagepanel;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.UnitOfMeasure;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.UnitOfMeasureComp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Ruler
extends JComponent {
    private static final long serialVersionUID = -7424236340175441151L;
    private static PropertyManager pm = PropertyManager.getInstance();
    public static final int dotsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int RULE_SIZE = 45;
    private UiUtils.Orientation o;
    private UnitOfMeasure uom;
    private int increment;
    private int units;

    public Ruler(UiUtils.Orientation o, UnitOfMeasure uom) {
        this.o = o;
        this.uom = uom;
        this.setIncrementAndUnits();
    }

    private void setIncrementAndUnits() {
        switch (this.uom) {
            case centimeters: {
                int cent;
                this.units = cent = (int)((double)dotsPerInch / 2.54);
                this.increment = cent;
                break;
            }
            case pixels: {
                this.units = 100;
                this.increment = 25;
                break;
            }
            default: {
                this.units = dotsPerInch;
                this.increment = this.units / 4;
            }
        }
    }

    public UnitOfMeasure getUom() {
        return this.uom;
    }

    public void setUnitOfMeasure(UnitOfMeasure uom) {
        this.uom = uom;
        this.setIncrementAndUnits();
        this.repaint();
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(45, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 45));
    }

    protected void paintComponent(Graphics g) {
        Rectangle drawHere = g.getClipBounds();
        g.setColor(UiUtils.ORANGE);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.black);
        int end = 0;
        int start = 0;
        int tickLength = 0;
        String text = null;
        if (this.o == UiUtils.Orientation.HORIZONTAL) {
            start = drawHere.x / this.increment * this.increment;
            end = ((drawHere.x + drawHere.width) / this.increment + 1) * this.increment;
        } else {
            start = drawHere.y / this.increment * this.increment;
            end = ((drawHere.y + drawHere.height) / this.increment + 1) * this.increment;
        }
        String suffix = "in";
        if (this.uom == UnitOfMeasure.pixels) {
            suffix = "px";
        } else if (this.uom == UnitOfMeasure.centimeters) {
            suffix = "cm";
        }
        if (start == 0) {
            text = String.valueOf(Integer.toString(0)) + " " + suffix;
            tickLength = 10;
            if (this.o == UiUtils.Orientation.HORIZONTAL) {
                g.drawLine(0, 44, 0, 45 - tickLength - 1);
                g.drawString(text, 2, 21);
            } else {
                g.drawLine(44, 0, 45 - tickLength - 1, 0);
                g.drawString(text, 9, 10);
            }
            text = null;
            start = this.increment;
        }
        int i = start;
        while (i < end) {
            if (i % this.units == 0) {
                tickLength = 10;
                if (this.uom == UnitOfMeasure.pixels) {
                    text = " " + Integer.toString(i);
                } else if (this.uom == UnitOfMeasure.centimeters) {
                    text = Integer.toString(i / this.units);
                    suffix = "";
                } else {
                    text = " " + Integer.toString(i / this.units);
                }
                text = String.valueOf(text) + suffix;
            } else {
                tickLength = 7;
                text = null;
            }
            if (tickLength != 0) {
                int offset = 8;
                if (this.o == UiUtils.Orientation.HORIZONTAL) {
                    g.drawLine(i, 44, i, 45 - tickLength - 1);
                    if (text != null) {
                        g.drawString(text, i - offset, 21);
                    }
                } else {
                    g.drawLine(44, i, 45 - tickLength - 1, i);
                    if (text != null) {
                        g.drawString(text, 9, i + offset);
                    }
                }
            }
            i += this.increment;
        }
    }

    private static void createAndShowGUI() {
        UnitOfMeasureComp myUomComp = new UnitOfMeasureComp();
        JPanel horzRuler = new JPanel(new FlowLayout(3));
        Ruler r = new Ruler(UiUtils.Orientation.HORIZONTAL, UnitOfMeasure.inches);
        final class RulerTester
        extends JFrame {
            private static final long serialVersionUID = 1L;

            RulerTester() {
            }
        }
        RulerTester frame = new RulerTester();
        frame.setDefaultCloseOperation(3);
        myUomComp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UnitOfMeasureComp c = (UnitOfMeasureComp)e.getSource();
                Ruler.this.setUnitOfMeasure(c.getUnitOfMeasure());
            }
        });
        int width = dotsPerInch * 8;
        int ht = dotsPerInch / 2;
        horzRuler.add(myUomComp);
        r.setPreferredSize(new Dimension(width, ht));
        horzRuler.add(r);
        frame.setContentPane(horzRuler);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Ruler : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Ruler.createAndShowGUI();
            }
        });
    }
}

