/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.imagepanel;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.RegionOfInterest;
import com.twainconnect.image.ImageUtils;
import com.twainconnect.ui.UiUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ScrollablePicture
extends JLabel
implements Scrollable {
    private static final long serialVersionUID = -2320540423222421795L;
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;
    private BufferedImage image;
    private BasicStroke bs;
    private GradientPaint gp;
    private RegionOfInterest roi = new RegionOfInterest();
    private int srcx;
    private int srcy;
    private int destx;
    private int desty;
    private Rectangle rectSelection;

    public ScrollablePicture(BufferedImage bi, int m) {
        super(new ImageIcon(bi));
        this.image = bi;
        if (this.image == null) {
            this.missingPicture = true;
            this.setText("No picture found.");
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        this.maxUnitIncrement = m;
        this.setAutoscrolls(true);
        this.createMouseListeners();
    }

    public ScrollablePicture() {
        super((Icon)null);
        this.createMouseListeners();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.srcx != this.destx || this.srcy != this.desty) {
            int x1 = this.srcx < this.destx ? this.srcx : this.destx;
            int y1 = this.srcy < this.desty ? this.srcy : this.desty;
            int x2 = this.srcx > this.destx ? this.srcx : this.destx;
            int y2 = this.srcy > this.desty ? this.srcy : this.desty;
            this.rectSelection.x = x1;
            this.rectSelection.y = y1;
            this.rectSelection.width = x2 - x1 + 1;
            this.rectSelection.height = y2 - y1 + 1;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(this.bs);
            g2d.setPaint(this.gp);
            g2d.draw(this.rectSelection);
        }
    }

    protected void createMouseListeners() {
        this.rectSelection = new Rectangle();
        this.bs = new BasicStroke(5.0f, 1, 1, 0.0f, new float[]{12.0f, 12.0f}, 0.0f);
        this.gp = new GradientPaint(0.0f, 0.0f, Color.red, 1.0f, 1.0f, Color.white, true);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (ScrollablePicture.this.image == null) {
                    return;
                }
                int n = e.getX();
                ScrollablePicture.this.srcx = n;
                ScrollablePicture.this.destx = n;
                int n2 = e.getY();
                ScrollablePicture.this.srcy = n2;
                ScrollablePicture.this.desty = n2;
                ScrollablePicture.this.repaint();
            }
        };
        this.addMouseListener(ml);
        MouseMotionAdapter mml = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (ScrollablePicture.this.image == null) {
                    return;
                }
                ScrollablePicture.this.destx = e.getX();
                ScrollablePicture.this.desty = e.getY();
                ScrollablePicture.this.repaint();
            }
        };
        this.addMouseMotionListener(mml);
    }

    public RegionOfInterest getRegionOfInterest() {
        this.roi.setWidth(this.rectSelection.width);
        this.roi.setHieght(this.rectSelection.height);
        this.roi.setLeft(this.rectSelection.x);
        this.roi.setTop(this.rectSelection.y);
        return this.roi;
    }

    public Dimension getPreferredSize() {
        Dimension dim = null;
        dim = this.missingPicture ? new Dimension(320, 480) : super.getPreferredSize();
        return dim;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int newPosition;
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        int result = direction < 0 ? ((newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement) == 0 ? this.maxUnitIncrement : newPosition) : (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
        return result;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int result = orientation == 0 ? visibleRect.width - this.maxUnitIncrement : visibleRect.height - this.maxUnitIncrement;
        return result;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    public boolean cropSelf() {
        if (this.srcx == this.destx && this.srcy == this.desty) {
            return true;
        }
        boolean succeeded = true;
        int x1 = this.srcx < this.destx ? this.srcx : this.destx;
        int y1 = this.srcy < this.desty ? this.srcy : this.desty;
        int x2 = this.srcx > this.destx ? this.srcx : this.destx;
        int y2 = this.srcy > this.desty ? this.srcy : this.desty;
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        BufferedImage biCrop = new BufferedImage(width, height, 1);
        Graphics2D g2d = biCrop.createGraphics();
        try {
            this.image = ImageUtils.toBufferedImage((ImageIcon)this.getIcon());
            BufferedImage bi2 = this.image.getSubimage(x1, y1, width, height);
            g2d.drawImage(bi2, null, 0, 0);
        }
        catch (RasterFormatException e) {
            succeeded = false;
        }
        g2d.dispose();
        if (succeeded) {
            this.setIcon(new ImageIcon(biCrop));
        }
        this.srcx = this.destx;
        this.srcy = this.desty;
        this.repaint();
        return succeeded;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        ScrollablePicture c = new ScrollablePicture(UiUtils.BLANK, 10);
        frame.setContentPane(c);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("ScrollablePicture  : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScrollablePicture.createAndShowGUI();
            }
        });
    }
}

