/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.tabs;

import com.twainconnect.core.UnitOfMeasure;
import com.twainconnect.ui.imagepanel.ImageScrollPanel;
import com.twainconnect.ui.tabs.CloseTabPaneEclipseUI;
import com.twainconnect.ui.tabs.CloseTabPaneUI;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;

public class CloseTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private int overTabIndex = -1;
    private CloseTabPaneUI paneUI = new CloseTabPaneEclipseUI();

    public CloseTabbedPane() {
        super.setTabLayoutPolicy(1);
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    public void setTabPlacement(int tabPlacement) {
    }

    public void setUI(TabbedPaneUI ui) {
    }

    public void setCloseIcon(boolean b) {
        this.paneUI.setCloseIcon(b);
    }

    public void detachTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        final JFrame frame = new JFrame();
        Window parentWindow = SwingUtilities.windowForComponent(this);
        final int tabIndex = index;
        final JComponent c = (JComponent)this.getComponentAt(tabIndex);
        final Icon icon = this.getIconAt(tabIndex);
        final String title = this.getTitleAt(tabIndex);
        final String toolTip = this.getToolTipTextAt(tabIndex);
        final Border border = c.getBorder();
        this.removeTabAt(index);
        c.setPreferredSize(c.getSize());
        frame.setTitle(title);
        frame.getContentPane().add(c);
        frame.setLocation(parentWindow.getLocation());
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                frame.dispose();
                CloseTabbedPane.this.insertTab(title, icon, c, toolTip, Math.min(tabIndex, CloseTabbedPane.this.getTabCount()));
                c.setBorder(border);
                CloseTabbedPane.this.setSelectedComponent(c);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            public void windowGainedFocus(WindowEvent e) {
                this.start = System.currentTimeMillis();
            }

            public void windowLostFocus(WindowEvent e) {
                this.end = System.currentTimeMillis();
                long elapsed = this.end - this.start;
                if (elapsed < 100L) {
                    frame.toFront();
                }
                frame.removeWindowFocusListener(this);
            }
        };
        frame.addWindowFocusListener(windowFocusListener);
        frame.setVisible(true);
        frame.toFront();
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(CloseListener.class, l);
    }

    public synchronized void addPopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.add(PopupOutsideListener.class, l);
    }

    public synchronized void removeCloseListener(CloseListener l) {
        this.listenerList.remove(CloseListener.class, l);
    }

    public synchronized void removePopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.remove(PopupOutsideListener.class, l);
    }

    public void fireCloseTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(CloseListener.class);
        int i = 0;
        while (i < closeListeners.length) {
            ((CloseListener)closeListeners[i]).closeOperation(e, overTabIndex);
            ++i;
        }
    }

    public void setUom(UnitOfMeasure unitOfMeasure) {
        Component c = this.getSelectedComponent();
        if (c instanceof ImageScrollPanel) {
            ImageScrollPanel sp = (ImageScrollPanel)c;
            sp.setUnitOfMeasure(unitOfMeasure);
        }
    }

    public void firePopupOutsideTabEvent(MouseEvent e) {
        this.overTabIndex = -1;
        EventListener[] popupListeners = this.getListeners(PopupOutsideListener.class);
        int i = 0;
        while (i < popupListeners.length) {
            ((PopupOutsideListener)popupListeners[i]).popupOutsideOperation(e);
            ++i;
        }
    }

    public static interface CloseListener
    extends EventListener {
        public void closeOperation(MouseEvent var1, int var2);
    }

    public static interface PopupOutsideListener
    extends EventListener {
        public void popupOutsideOperation(MouseEvent var1);
    }
}

