/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.image.ImageUtils;
import java.awt.image.BufferedImage;

public class AcquiredImage {
    private BufferedImage image;
    private BufferedImage thumbnail;

    public AcquiredImage(BufferedImage image, BufferedImage thumbnail) {
        this.image = image;
        this.thumbnail = thumbnail;
    }

    public AcquiredImage(BufferedImage image, int width, int height) {
        this.image = image;
        this.thumbnail = ImageUtils.getScaledBufferedImage(image, width, height);
    }

    public AcquiredImage(BufferedImage image) {
        this.image = image;
        this.buildThumbnail();
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.buildThumbnail();
    }

    private void buildThumbnail() {
        int w;
        int h = this.image.getHeight() / 20;
        if (h < 50) {
            h = this.image.getHeight() / 10;
        }
        if ((w = this.image.getWidth() / 20) < 50) {
            w = this.image.getWidth() / 10;
        }
        this.thumbnail = ImageUtils.getScaledBufferedImage(this.image, w, h);
    }
}

