/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.BitDepth;
import com.twainconnect.core.PropertyManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BitDepthComp
extends JPanel {
    private static final long serialVersionUID = 3689406951304905111L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private static Logger LOGGER = Logger.getLogger(BitDepthComp.class.getName());
    private JComboBox bitdepth;
    private JLabel bitdepthLabel;
    private JPanel enableDisablePanel;

    public BitDepthComp(ActionListener l) {
        this.createContent();
        this.bitdepth.addActionListener(l);
    }

    public BitDepthComp() {
        this.createContent();
    }

    protected void createContent() {
        this.setOpaque(false);
        this.enableDisablePanel = new JPanel(new FlowLayout(3, 4, 0));
        this.enableDisablePanel.setOpaque(false);
        String result = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_bit_depth");
        this.bitdepth = new JComboBox<Object>(new Object[]{BitDepth.color, BitDepth.gray, BitDepth.bw});
        this.bitdepthLabel = new JLabel(result);
        this.bitdepth.setPreferredSize(new Dimension(60, 30));
        result = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_bit_depth_tooltip");
        this.bitdepth.setToolTipText(result);
        this.bitdepthLabel.setToolTipText(result);
        this.bitdepth.setEnabled(true);
        this.add(this.bitdepthLabel);
        this.enableDisablePanel.add(this.bitdepth);
        this.add(this.enableDisablePanel);
    }

    public BitDepth getBitDepth() {
        BitDepth o = (BitDepth)((Object)this.bitdepth.getSelectedItem());
        LOGGER.finest("Selected " + (Object)((Object)o));
        return o;
    }

    public void setBitDepth(BitDepth bit) {
        this.bitdepth.setSelectedItem((Object)bit);
        LOGGER.finest("Selected " + (Object)((Object)bit));
    }

    protected void enableControls(boolean b) {
        Component[] c = this.enableDisablePanel.getComponents();
        int i = 0;
        while (i < c.length) {
            Component component = c[i];
            component.setEnabled(b);
            ++i;
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        BitDepthComp c = new BitDepthComp(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BitDepthComp bc = (BitDepthComp)e.getSource();
                System.out.println("Selected " + (Object)((Object)bc.getBitDepth()));
            }
        });
        frame.setContentPane(c);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("BitDepthComp  : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BitDepthComp.createAndShowGUI();
            }
        });
    }
}

