/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.RegionOfInterest;
import com.twainconnect.ui.SpringLayoutUtilities;
import com.twainconnect.ui.widgets.UnitOfMeasureComp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class CropUnits
extends JPanel {
    private static final long serialVersionUID = -7207269193719684928L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private JCheckBox cropEnabled;
    private boolean cropImage = false;
    private UnitOfMeasureComp uomComp = new UnitOfMeasureComp();
    private JTextField top;
    private JTextField bottom;
    private JTextField right;
    private JTextField left;
    private JPanel unitsPanel = new JPanel(new SpringLayout());

    public CropUnits() {
        this.createContentPanel();
    }

    public CropUnits(ActionListener l) {
        this.createContentPanel();
        this.uomComp.addActionListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.uomComp.addActionListener(l);
    }

    protected void createContentPanel() {
        this.setOpaque(false);
        this.unitsPanel.setOpaque(false);
        String name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_device_crop_enabled");
        this.setLayout(new FlowLayout(3, 0, 0));
        this.cropEnabled = new JCheckBox(name, true);
        this.cropEnabled.setOpaque(false);
        this.cropEnabled.setSelected(false);
        this.cropEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CropUnits.this.cropImage = e.getStateChange() == 1;
                CropUnits.this.enableControls(CropUnits.this.cropImage);
            }
        });
        this.add(this.cropEnabled);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_crop_tooltip");
        this.setToolTipText(name);
        int COL_LEN = 3;
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_top");
        JLabel topLab = new JLabel(name, 11);
        this.top = new JTextField("0");
        topLab.setLabelFor(this.top);
        this.top.setColumns(COL_LEN);
        this.unitsPanel.add(topLab);
        this.unitsPanel.add(this.top);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_left");
        JLabel leftLab = new JLabel(name, 11);
        this.left = new JTextField("0");
        leftLab.setLabelFor(this.left);
        this.left.setColumns(COL_LEN);
        this.unitsPanel.add(leftLab);
        this.unitsPanel.add(this.left);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_right");
        JLabel rightLab = new JLabel(name, 11);
        this.right = new JTextField("3");
        rightLab.setLabelFor(this.right);
        this.right.setColumns(COL_LEN);
        this.unitsPanel.add(rightLab);
        this.unitsPanel.add(this.right);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_bottom");
        JLabel bottomLab = new JLabel(name, 11);
        this.bottom = new JTextField("6");
        bottomLab.setLabelFor(this.right);
        this.bottom.setColumns(COL_LEN);
        this.unitsPanel.add(bottomLab);
        this.unitsPanel.add(this.bottom);
        this.uomComp.setPreferredSize(new Dimension(50, 25));
        this.unitsPanel.add(this.uomComp);
        SpringLayoutUtilities.makeCompactGrid(this.unitsPanel, 1, this.unitsPanel.getComponentCount(), 2, 2, 2, 2);
        this.add(this.unitsPanel);
        this.enableControls(false);
    }

    public boolean isSelected() {
        return this.cropEnabled.isSelected();
    }

    protected void enableControls(boolean b) {
        Component[] c = this.unitsPanel.getComponents();
        int i = 0;
        while (i < c.length) {
            Component component = c[i];
            component.setEnabled(b);
            ++i;
        }
    }

    public RegionOfInterest getRoi() {
        float t = Float.parseFloat(this.top.getText());
        float b = Float.parseFloat(this.bottom.getText());
        float r = Float.parseFloat(this.right.getText());
        float l = Float.parseFloat(this.left.getText());
        RegionOfInterest roi = new RegionOfInterest();
        roi.setTop(t);
        roi.setBottom(b);
        roi.setRight(r);
        roi.setLeft(l);
        roi.setUom(this.uomComp.getUnitOfMeasure());
        return roi;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new CropUnits());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Cropped Units : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CropUnits.createAndShowGUI();
            }
        });
    }
}

