/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.Dpi;
import com.twainconnect.core.PropertyManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DpiComp
extends JPanel {
    private static final long serialVersionUID = -8086086279483767931L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private static Logger LOGGER = Logger.getLogger(DpiComp.class.getName());
    private JComboBox dpi;
    private JCheckBox label;
    private JPanel enableDisablePanel;

    public DpiComp(ActionListener l) {
        this.createContent();
        this.dpi.addActionListener(l);
    }

    public DpiComp() {
        this.createContent();
    }

    protected void createContent() {
        this.setOpaque(false);
        this.enableDisablePanel = new JPanel(new FlowLayout(3, 4, 0));
        this.enableDisablePanel.setOpaque(false);
        String result = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_dpi");
        this.dpi = new JComboBox<Object>(new Object[]{Dpi.one_hundred, Dpi.two_hundred, Dpi.three_hundred, Dpi.one_hundred, Dpi.six_hundred, Dpi.eight_hundred, Dpi.one_thousand, Dpi.twelve_hundred, Dpi.sixteen_hundred, Dpi.nine_teen_thousand, Dpi.thirty_two_thousand});
        this.dpi.setOpaque(false);
        this.label = new JCheckBox(result);
        this.label.setOpaque(false);
        this.label.setSelected(false);
        this.label.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean cropImage = e.getStateChange() == 1;
                DpiComp.this.enableControls(cropImage);
            }
        });
        this.dpi.setPreferredSize(new Dimension(60, 30));
        result = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_dpi_tooltip");
        this.dpi.setToolTipText(result);
        this.dpi.setEnabled(false);
        this.label.setToolTipText(result);
        this.add(this.label);
        this.enableDisablePanel.add(this.dpi);
        this.add(this.enableDisablePanel);
    }

    public Dpi getDPI() {
        Dpi o = (Dpi)((Object)this.dpi.getSelectedItem());
        LOGGER.finest("DPI " + (Object)((Object)o));
        return o;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        DpiComp c = new DpiComp(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DpiComp bc = (DpiComp)e.getSource();
                System.out.println("Selected " + (Object)((Object)bc.getDPI()));
            }
        });
        frame.setContentPane(c);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("BitDepthComp  : " + title);
    }

    public boolean isSelected() {
        return this.label.isSelected();
    }

    protected void enableControls(boolean b) {
        Component[] c = this.enableDisablePanel.getComponents();
        int i = 0;
        while (i < c.length) {
            Component component = c[i];
            component.setEnabled(b);
            ++i;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DpiComp.createAndShowGUI();
            }
        });
    }
}

