/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.TwainUsability;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ExportComponent
extends JButton
implements TwainUsability {
    private static final long serialVersionUID = 186789897L;
    private PropertyManager pm = PropertyManager.getInstance();

    public ExportComponent(ActionListener al) {
        this();
        this.addActionListener(al);
    }

    public ExportComponent() {
        this.createContent();
    }

    protected void createContent() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_export_tip");
        this.setToolTipText(name);
        this.showAsImage();
    }

    public ImageIcon getUsabiltyImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_export");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        return ico;
    }

    public String getUsabiltyText() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_export");
        return name;
    }

    public void showAsImage() {
        this.setIcon(this.getUsabiltyImage());
        this.setText("");
    }

    public void showAsImageText() {
        this.showAsImage();
        this.showAsText();
    }

    public void showAsText() {
        this.setText(this.getUsabiltyText());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new ExportComponent());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Acquire Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExportComponent.createAndShowGUI();
            }
        });
    }
}

