/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.jimageconnect.core.JImageSourceInfo;
import com.jimageconnect.core.JImageconnect;
import com.jimageconnect.directshow.DirectShowConnect;
import com.jimageconnect.directshow.DirectShowEngineType;
import com.twainconnect.core.TwainConnect;
import com.twainconnect.core.TwainEngineType;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ImageDevices
extends JComboBox {
    private static final long serialVersionUID = -6650574187067498820L;
    private static Logger LOGGER = Logger.getLogger(ImageDevices.class.getName());

    public ImageDevices(JImageconnect imageEngine) {
        this.setRenderer(new JImageEngineTypeComboBoxRenderer());
        this.addContent(imageEngine);
    }

    public void addSource(JImageconnect imageEngine) {
        this.addContent(imageEngine);
    }

    private void addContent(JImageconnect imageEngine) {
        if (imageEngine != null && imageEngine.isEngineAvailble()) {
            String[] sources = imageEngine.getAvailableSources();
            if (sources != null && sources.length > 0) {
                int i = 0;
                while (i < sources.length) {
                    JImageSourceInfo type;
                    if (imageEngine instanceof TwainConnect) {
                        type = new TwainEngineType(sources[i]);
                        this.addItem(type);
                    } else if (imageEngine instanceof DirectShowConnect) {
                        type = new DirectShowEngineType(sources[i]);
                        this.addItem(type);
                    }
                    ++i;
                }
            } else {
                this.addItem("label_none_available_msg");
                LOGGER.finest("label_none_available_msg");
            }
        }
    }

    class JImageEngineTypeComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -8203227882763724833L;

        JImageEngineTypeComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList arg0, Object obj, int arg2, boolean arg3, boolean arg4) {
            if (obj instanceof JImageSourceInfo) {
                JImageSourceInfo type = (JImageSourceInfo)obj;
                this.setText(type.getSourceName());
            }
            return this;
        }
    }
}

