/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.TwainUsability;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ImageIOTypeComponent
extends JCheckBox
implements ItemListener,
TwainUsability {
    private static final long serialVersionUID = -6176343313209520276L;
    private PropertyManager pm = PropertyManager.getInstance();

    public ImageIOTypeComponent() {
        this.createContent();
    }

    public boolean isUsingMemory() {
        return this.isSelected();
    }

    public boolean isUsingFile() {
        return !this.isSelected();
    }

    public void itemStateChanged(ItemEvent e) {
        String text;
        String tooltip;
        if (this.isSelected()) {
            tooltip = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_file_tooltip");
            text = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_file");
        } else {
            tooltip = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory_tooltip");
            text = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory");
        }
        if (this.getText() != null && this.getText().length() > 0) {
            this.setText(text);
        }
        this.setToolTipText(tooltip);
    }

    public void setUseMemory() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory");
        this.setText(name);
        this.setSelected(false);
    }

    public void setUseFile() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_file");
        this.setText(name);
        this.setSelected(true);
    }

    public ImageIcon getUsabiltyImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image.use_memory");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        return ico;
    }

    public void showAsImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image.use_file");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        this.setSelectedIcon(ico);
        this.setPressedIcon(ico);
        this.setIcon(this.getUsabiltyImage());
        this.setText("");
    }

    public void showAsImageText() {
        this.showAsImage();
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory");
        this.setText(name);
    }

    public void showAsText() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_file");
        if (this.isSelected()) {
            name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory");
        }
        this.setText(name);
        this.setIcon(null);
    }

    protected void createContent() {
        this.setBorderPainted(true);
        this.setOpaque(true);
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.use_memory_tooltip");
        this.setToolTipText(name);
        this.addItemListener(this);
        this.showAsImage();
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new ImageIOTypeComponent());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Acquire Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImageIOTypeComponent.createAndShowGUI();
            }
        });
    }

    public String getUsabiltyText() {
        return this.getText();
    }
}

