/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.TwainUsability;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Rotate270ImageComponent
extends JButton
implements TwainUsability {
    private static final long serialVersionUID = 287955676730391126L;
    private PropertyManager pm = PropertyManager.getInstance();

    public Rotate270ImageComponent() {
        this.createContent();
    }

    protected void createContent() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_rotate_270_tooltip");
        this.setToolTipText(name);
        this.showAsImage();
    }

    public ImageIcon getUsabiltyImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_rotate_270");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        return ico;
    }

    public void showAsImage() {
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setIcon(this.getUsabiltyImage());
        this.setText("");
    }

    public void showAsImageText() {
        this.showAsImage();
        this.showAsText();
    }

    public void showAsText() {
        this.setText(this.getUsabiltyText());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new Rotate270ImageComponent());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Acquire Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Rotate270ImageComponent.createAndShowGUI();
            }
        });
    }

    public String getUsabiltyText() {
        return this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_rotate_270");
    }
}

