/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.TwainUsability;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Rotate90ImageComponent
extends JButton
implements TwainUsability {
    private static final long serialVersionUID = -3753142585914252006L;
    private PropertyManager pm = PropertyManager.getInstance();

    public Rotate90ImageComponent() {
        this.createContent();
    }

    protected void createContent() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_rotate_90_tooltip");
        this.setToolTipText(name);
        this.showAsImage();
    }

    public String getUsabiltyText() {
        return this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_rotate_90");
    }

    public ImageIcon getUsabiltyImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_rotate_90");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        return ico;
    }

    public void showAsImage() {
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setIcon(this.getUsabiltyImage());
        this.setText("");
    }

    public void showAsImageText() {
        this.showAsImage();
        this.showAsText();
    }

    public void showAsText() {
        this.setText(this.getUsabiltyText());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new Rotate90ImageComponent());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Acquire Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Rotate90ImageComponent.createAndShowGUI();
            }
        });
    }
}

