/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleComp
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    static final int SCALE_MIN = 0;
    static final int SCALE_MAX = 100;
    static final int SCALE_INIT_VAL = 100;
    private static final long serialVersionUID = 2688293609669443122L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private static Logger LOGGER = Logger.getLogger(ScaleComp.class.getName());
    private static String rootLabel;
    private JSlider scale;
    private JCheckBox label;

    public ScaleComp() {
        this.createContent();
    }

    protected void createContent() {
        String name;
        this.setOpaque(false);
        rootLabel = name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_scale");
        this.label = new JCheckBox(String.valueOf(rootLabel) + "100%");
        this.label.setOpaque(false);
        this.label.setAlignmentX(0.5f);
        this.label.setSelected(false);
        this.label.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = e.getStateChange() == 1;
                ScaleComp.this.enableControls(b);
            }
        });
        this.scale = new JSlider(0, 0, 100, 100);
        this.scale.setOpaque(false);
        this.scale.setMajorTickSpacing(25);
        this.scale.setMinorTickSpacing(5);
        this.scale.setPaintTicks(true);
        this.scale.setPaintTrack(true);
        this.scale.setPreferredSize(new Dimension(200, 35));
        this.scale.addChangeListener(this);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_scale_tool_tip");
        this.scale.setToolTipText(name);
        this.scale.setEnabled(false);
        this.label.setToolTipText(name);
        this.add(this.label);
        this.add(this.scale);
    }

    public short getScale() {
        short v = (short)this.scale.getValue();
        LOGGER.finest("Scale " + v);
        return v;
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int fps = source.getValue();
        if (!source.getValueIsAdjusting()) {
            this.label.setText(String.valueOf(rootLabel) + new Integer(fps) + "%");
        } else {
            this.label.setText(String.valueOf(rootLabel) + String.valueOf(fps) + "%");
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("value".equals(e.getPropertyName())) {
            Number value = (Number)e.getNewValue();
            if (this.scale != null && value != null) {
                this.scale.setValue(value.intValue());
            }
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new ScaleComp());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("BitDepthComp  : " + title);
    }

    public boolean isSelected() {
        return this.label.isSelected();
    }

    protected void enableControls(boolean b) {
        this.scale.setEnabled(b);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScaleComp.createAndShowGUI();
            }
        });
    }
}

