/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.UiUtils;
import com.twainconnect.ui.widgets.TwainUsability;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ShowUiComponent
extends JCheckBox
implements TwainUsability {
    private static final long serialVersionUID = -6176343313209520276L;
    private PropertyManager pm = PropertyManager.getInstance();

    public ShowUiComponent(ActionListener al) {
        this();
        this.addActionListener(al);
    }

    public ShowUiComponent() {
        this.createContent();
    }

    protected void createContent() {
        this.setBorderPainted(true);
        this.setOpaque(true);
        this.setLayout(new FlowLayout(3, 0, 0));
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.show_ui_button_tooltip");
        this.setToolTipText(name);
        this.showAsImage();
    }

    public ImageIcon getUsabiltyImage() {
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_show_ui");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        return ico;
    }

    public void showAsImage() {
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_show_ui");
        ImageIcon ico = UiUtils.getIconFromResource(name, this.getClass());
        this.setIcon(ico);
        name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "image_dont_show_ui");
        ico = UiUtils.getIconFromResource(name, this.getClass());
        this.setPressedIcon(ico);
        this.setSelectedIcon(ico);
        this.setText("");
    }

    public void showAsImageText() {
        this.showAsImage();
        String name = this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.show_ui_button");
        this.setText(name);
    }

    public String getUsabiltyText() {
        return this.pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label.show_ui_button");
    }

    public void showAsText() {
        this.setText(this.getUsabiltyText());
        this.setIcon(null);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new ShowUiComponent());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("Acquire Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ShowUiComponent.createAndShowGUI();
            }
        });
    }
}

