/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class StatusBar
extends JPanel {
    static final long serialVersionUID = -5045623371756545699L;
    private JLabel label = new JLabel();
    private JProgressBar indeterminatePB = new JProgressBar();
    private Font SMALL_FONT = new Font("Dialog", 0, 10);
    private Stack<JProgressBar> stackProgressBar = new Stack();
    private Timer timerLabel = new Timer(0, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            StatusBar.this.removeLabel();
        }
    });

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.timerLabel.setRepeats(false);
        this.add((Component)new JLabel(" "), "West");
        this.indeterminatePB.setIndeterminate(true);
    }

    public synchronized void setLabel(JLabel _label) {
        if (this.timerLabel.isRunning()) {
            this.timerLabel.stop();
        }
        this.removeLabel();
        this.label = _label;
        this.label.setToolTipText(this.label.getText());
        this.label.setFont(this.SMALL_FONT);
        this.add((Component)this.label, "Center");
        this.updateUI();
    }

    public synchronized void setLabel(String s) {
        this.setLabel(new JLabel(s));
    }

    public synchronized void setLabel(JLabel _label, int secTime) {
        this.setLabel(_label);
        this.timerLabel.setInitialDelay(secTime * 1000);
        this.timerLabel.start();
    }

    public synchronized void setLabel(String _label, int secTime) {
        this.setLabel(new JLabel(_label), secTime);
    }

    public synchronized void setProgressBar(JProgressBar pb) {
        if (!this.stackProgressBar.empty()) {
            this.remove(this.stackProgressBar.peek());
        }
        this.stackProgressBar.push(pb);
        this.add((Component)pb, "East");
    }

    public synchronized void removeLabel() {
        this.remove(this.label);
        this.label = new JLabel(" ");
        this.add((Component)this.label, "Center");
        this.updateUI();
    }

    public synchronized void removeProgressBar(JProgressBar p) {
        if (p == null) {
            return;
        }
        this.remove(p);
        if (this.stackProgressBar.contains(p)) {
            this.stackProgressBar.remove(p);
        }
        if (!this.stackProgressBar.isEmpty()) {
            this.setProgressBar(this.stackProgressBar.pop());
        }
        this.updateUI();
    }

    public synchronized void setAnimateProgressBar(boolean b) {
        if (b) {
            this.setProgressBar(this.indeterminatePB);
        } else {
            this.removeProgressBar(this.indeterminatePB);
            this.indeterminatePB.removeAll();
        }
    }

    public void addIndeterminateProgressBarMouseListener(MouseListener ml) {
        this.indeterminatePB.addMouseListener(ml);
    }

    public void setIndeterminateProgressBarToolTip(String s) {
        this.indeterminatePB.setToolTipText(s);
    }
}

