/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.ui.widgets.AcquiredImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

public class ThumbnailComboBox
extends JList {
    private static final long serialVersionUID = -6965494812499802646L;
    private static Logger LOGGER = Logger.getLogger(ThumbnailComboBox.class.getName());
    private static PropertyManager pm = PropertyManager.getInstance();
    private JMenuItem delmenuItem;
    private JMenuItem exportmenuItem;
    private JMenuItem copymenuItem;
    private JPopupMenu popup = new JPopupMenu();
    ActionListener delMenuListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            LOGGER.warning("Popup menu item [" + event.getActionCommand() + "] was pressed.");
            ThumbnailComboBox.this.deleteSelectedAcquiredImage();
        }
    };

    public ThumbnailComboBox(DefaultListModel model) {
        super(model);
        this.init();
    }

    private void init() {
        ComboBoxRenderer renderer = new ComboBoxRenderer();
        this.setCellRenderer(renderer);
        this.setSelectionMode(0);
        this.setBorder(new EtchedBorder(0));
        String name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_delete_image");
        this.delmenuItem = new JMenuItem(name);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_export");
        this.exportmenuItem = new JMenuItem(name);
        name = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_copy_menu");
        this.copymenuItem = new JMenuItem(name);
        this.popup.add(this.delmenuItem);
        this.popup.add(this.exportmenuItem);
        this.popup.add(this.copymenuItem);
        this.delmenuItem.addActionListener(this.delMenuListener);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                boolean isSelIndex;
                boolean isRightMouse = SwingUtilities.isRightMouseButton(me);
                boolean isSelEmpty = ThumbnailComboBox.this.isSelectionEmpty();
                boolean bl = isSelIndex = ThumbnailComboBox.this.locationToIndex(me.getPoint()) == ThumbnailComboBox.this.getSelectedIndex();
                if (isRightMouse && !isSelEmpty && isSelIndex) {
                    ThumbnailComboBox.this.popup.show(ThumbnailComboBox.this, me.getX(), me.getY());
                }
            }
        });
    }

    public void addExportActionListener(ActionListener l) {
        this.exportmenuItem.addActionListener(l);
    }

    public void addCopyActionListener(ActionListener l) {
        this.copymenuItem.addActionListener(l);
    }

    public void deleteSelectedAcquiredImage() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.remove(this.getSelectedIndex());
        this.setModel(model);
        this.validate();
        if (model.getSize() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void addAcquiredImage(AcquiredImage ai) {
        if (ai != null) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            int pos = model.getSize();
            model.add(pos, ai);
            this.validate();
        }
    }

    public BufferedImage getSelectedImage() {
        BufferedImage bi = null;
        AcquiredImage ai = null;
        int pos = this.getSelectedIndex();
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (model != null) {
            ai = (AcquiredImage)model.getElementAt(pos);
        }
        if (ai != null) {
            bi = ai.getImage();
        }
        return bi;
    }

    class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1041999892097491263L;

        public ComboBoxRenderer() {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof AcquiredImage) {
                    AcquiredImage ai = (AcquiredImage)value;
                    ImageIcon icon = new ImageIcon(ai.getThumbnail());
                    this.setIcon(icon);
                    String text = String.valueOf(String.valueOf(index + 1)) + " of " + list.getModel().getSize();
                    this.setText(text);
                    this.setFont(list.getFont());
                } else {
                    LOGGER.warning("The model value is null");
                }
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
            }
            return this;
        }
    }
}

