/*
 * Decompiled with CFR 0.152.
 */
package com.twainconnect.ui.widgets;

import com.twainconnect.core.PropertyManager;
import com.twainconnect.core.UnitOfMeasure;
import com.twainconnect.ui.UiUtils;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class UnitOfMeasureComp
extends JComboBox {
    private static final long serialVersionUID = 3689406951304905111L;
    private static PropertyManager pm = PropertyManager.getInstance();
    private static Logger LOGGER = Logger.getLogger(UnitOfMeasureComp.class.getName());

    public UnitOfMeasureComp(ActionListener l) {
        this();
        this.createContent();
        this.addActionListener(l);
    }

    public UnitOfMeasureComp() {
        super(new Object[]{UnitOfMeasure.inches, UnitOfMeasure.centimeters, UnitOfMeasure.pixels});
        this.createContent();
    }

    protected void createContent() {
        this.setOpaque(false);
        this.setFont(UiUtils.getMetricFont());
        this.setPreferredSize(new Dimension(30, 30));
        String result = pm.getValue("com/twainconnect/ui/twainconnect_ui.properties", "label_uom");
        this.setToolTipText(result);
    }

    public UnitOfMeasure getUnitOfMeasure() {
        UnitOfMeasure o = (UnitOfMeasure)((Object)this.getSelectedItem());
        LOGGER.finest("Selected " + (Object)((Object)o));
        return o;
    }

    public void setUnitOfMeasure(UnitOfMeasure uom) {
        this.setSelectedItem((Object)uom);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new UnitOfMeasureComp());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        PropertyManager pm = PropertyManager.getInstance();
        String title = "DLL ver : " + pm.getValue("version");
        frame.setTitle("UOM Button : " + title);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UnitOfMeasureComp.createAndShowGUI();
            }
        });
    }
}

