/*
 * Decompiled with CFR 0.152.
 */
package com.verdiseno;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage flipVertically(BufferedImage bufferedImage) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -bufferedImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static BufferedImage flipHorizontally(BufferedImage bufferedImage) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-bufferedImage.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static BufferedImage flipUpsideDown(BufferedImage bufferedImage) {
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bufferedImage = op.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static BufferedImage rotate90(BufferedImage originalImage) {
        double degrees = 90.0;
        double radians = Math.toRadians(degrees);
        return ImageUtils.getRotatedImage(originalImage, radians);
    }

    public static BufferedImage rotate270(BufferedImage originalImage) {
        double degrees = -90.0;
        double radians = Math.toRadians(degrees);
        return ImageUtils.getRotatedImage(originalImage, radians);
    }

    public static BufferedImage rotate180(BufferedImage originalImage) {
        double degrees = 180.0;
        double radians = Math.toRadians(degrees);
        return ImageUtils.getRotatedImage(originalImage, radians);
    }

    public static BufferedImage rotate360(BufferedImage originalImage) {
        double degrees = 360.0;
        double radians = Math.toRadians(degrees);
        return ImageUtils.getRotatedImage(originalImage, radians);
    }

    public static BufferedImage getRotatedImage(BufferedImage bImage, double theta) {
        theta = (theta % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
        double x = 0.0;
        double y = 0.0;
        double alpha = 0.0;
        double w = bImage.getWidth();
        double h = bImage.getHeight();
        if (theta >= 0.0 && theta <= 1.5707963267948966) {
            x = h * Math.sin(theta);
            y = 0.0;
        }
        if (theta > 1.5707963267948966 && theta <= Math.PI) {
            alpha = theta - 1.5707963267948966;
            x = w * Math.sin(alpha) + h * Math.cos(alpha);
            y = h * Math.sin(alpha);
        }
        if (theta > Math.PI && theta <= 4.71238898038469) {
            alpha = theta - Math.PI;
            x = w * Math.cos(alpha);
            y = w * Math.sin(alpha) + h * Math.cos(alpha);
        }
        if (theta > 4.71238898038469 && theta <= Math.PI * 2) {
            alpha = Math.PI * 2 - theta;
            x = 0.0;
            y = w * Math.sin(alpha);
        }
        AffineTransform atx = AffineTransform.getTranslateInstance(x, y);
        atx.rotate(theta);
        AffineTransformOp op = new AffineTransformOp(atx, 2);
        BufferedImage result = op.filter(bImage, null);
        return result;
    }

    public static BufferedImage crop(BufferedImage image, int srcx, int destx, int srcy, int desty) {
        if (srcx == destx && srcy == desty) {
            return null;
        }
        boolean succeeded = true;
        int x1 = srcx < destx ? srcx : destx;
        int y1 = srcy < desty ? srcy : desty;
        int x2 = srcx > destx ? srcx : destx;
        int y2 = srcy > desty ? srcy : desty;
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        BufferedImage biCrop = new BufferedImage(width, height, 1);
        Graphics2D g2d = biCrop.createGraphics();
        try {
            BufferedImage bi = image;
            BufferedImage bi2 = bi.getSubimage(x1, y1, width, height);
            g2d.drawImage(bi2, null, 0, 0);
        }
        catch (RasterFormatException e) {
            succeeded = false;
        }
        g2d.dispose();
        if (!succeeded) {
            srcx = destx;
            srcy = desty;
        }
        return biCrop;
    }

    public static BufferedImage toBufferedImage(ImageIcon img) {
        return ImageUtils.toBufferedImage(img.getImage());
    }

    public static BufferedImage toBufferedImage(Image img) {
        img = new ImageIcon(img).getImage();
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static ImageIcon asIcon(BufferedImage bi) {
        return new ImageIcon(bi, "");
    }

    public static ImageIcon getScaledIcon(BufferedImage image, int widthDesired, int heightDesired) {
        int w = image.getWidth();
        int h = image.getHeight();
        double xScale = (double)widthDesired / (double)w;
        double yScale = (double)heightDesired / (double)h;
        double scale = Math.min(xScale, yScale);
        double x = ((double)widthDesired - scale * (double)w) / 2.0;
        double y = ((double)heightDesired - scale * (double)h) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.scale(scale, scale);
        BufferedImage thumbnail = new BufferedImage(widthDesired, heightDesired, image.getType());
        Graphics2D g2 = thumbnail.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setPaint(UIManager.getColor("Panel.background"));
        g2.fillRect(0, 0, w, h);
        g2.drawRenderedImage(image, at);
        g2.dispose();
        String size = String.valueOf(String.valueOf(w)) + "," + h;
        return new ImageIcon(thumbnail, size);
    }

    public static BufferedImage getScaledBufferedImage(BufferedImage image, int width, int height) {
        int w = image.getWidth();
        int h = image.getHeight();
        double xScale = (double)width / (double)w;
        double yScale = (double)height / (double)h;
        double scale = Math.min(xScale, yScale);
        double x = ((double)width - scale * (double)w) / 2.0;
        double y = ((double)height - scale * (double)h) / 2.0;
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        at.scale(scale, scale);
        BufferedImage thumbnail = new BufferedImage(width, height, image.getType());
        Graphics2D g2 = thumbnail.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setPaint(UIManager.getColor("Panel.background"));
        g2.fillRect(0, 0, w, h);
        g2.drawRenderedImage(image, at);
        g2.dispose();
        return thumbnail;
    }

    public static void copyToClipboard(BufferedImage bi, ClipboardOwner owner) {
        int imgWid = bi.getWidth();
        int imgHt = bi.getHeight();
        int[] pix = new int[imgWid * imgHt];
        BufferedImage bufImg = new BufferedImage(imgWid, imgHt, 2);
        DataFlavor myFlavor = DataFlavor.imageFlavor;
        PixelGrabber pixGrab = new PixelGrabber(bi, 0, 0, imgWid, imgHt, pix, 0, imgWid);
        try {
            pixGrab.grabPixels();
        }
        catch (InterruptedException e) {
            System.out.println("Caught interrupted exception");
        }
        bufImg.setRGB(0, 0, imgWid, imgHt, pix, 0, imgWid);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        final class MyImageSelection
        implements Transferable {
            private final /* synthetic */ DataFlavor val$myFlavor;
            private final /* synthetic */ BufferedImage val$bufImg;

            MyImageSelection(DataFlavor dataFlavor, BufferedImage bufferedImage) {
                this.val$myFlavor = dataFlavor;
                this.val$bufImg = bufferedImage;
            }

            public synchronized DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.val$myFlavor};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return this.val$myFlavor.equals(flavor);
            }

            public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (!this.val$myFlavor.equals(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.val$bufImg;
            }
        }
        MyImageSelection selec = new MyImageSelection(myFlavor, bufImg);
        clipboard.setContents(selec, owner);
    }

    public static BufferedImage byteArrayToBufferdImage(byte[] array) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(array);
        BufferedImage bImageFromConvert = ImageIO.read(in);
        return bImageFromConvert;
    }

    public static byte[] bufferdImageToByteArrayJpg(BufferedImage image) throws IOException {
        return ImageUtils.bufferdImageToByteArray(image, "jpg");
    }

    public static byte[] bufferdImageToByteArrayPng(BufferedImage image) throws IOException {
        return ImageUtils.bufferdImageToByteArray(image, "png");
    }

    public static byte[] bufferdImageToByteArrayGif(BufferedImage image) throws IOException {
        return ImageUtils.bufferdImageToByteArray(image, "gif");
    }

    public static byte[] bufferdImageToByteArray(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    public static void main(String[] args) {
        try {
            String urlLocation = "http://www.guru.com/upload/projects/371613/A3DEAC5F-FC57-4064-B89B7C86C06319D7/image.jpg";
            URL url = new URL(urlLocation);
            BufferedImage originalImage = ImageIO.read(url);
            byte[] imageInBytesJpg = ImageUtils.bufferdImageToByteArrayJpg(originalImage);
            byte[] imageInBytesGif = ImageUtils.bufferdImageToByteArrayGif(originalImage);
            byte[] imageInBytesPng = ImageUtils.bufferdImageToByteArrayPng(originalImage);
            BufferedImage newImage = ImageUtils.byteArrayToBufferdImage(imageInBytesJpg);
            ImageIO.write((RenderedImage)newImage, "jpg", new File("c:\\mypic_new.jpg"));
            newImage = ImageUtils.byteArrayToBufferdImage(imageInBytesGif);
            ImageIO.write((RenderedImage)newImage, "gif", new File("c:\\mypic_new.gif"));
            newImage = ImageUtils.byteArrayToBufferdImage(imageInBytesPng);
            ImageIO.write((RenderedImage)newImage, "png", new File("c:\\mypic_new.png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

