/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.swing.ImageIconCache;
import javax.swing.JButton;

public class ButtonFactory {
    private static final int TEXT_ICON_GAP = 3;
    private static final String BUT_BIOX = "but-biox";
    private static final String BUT_TAB_NEXT = "but-tab-next";
    private static final String BUT_TAB_PREVIOUS = "but-tab-previous";
    private static final String BUT_SAVE = "but-save";
    private static final String BUT_PRINT = "but-print";
    private static final String BUT_SEARCH = "but-search";
    private static final String BUT_WEB_SEARCH = "but-webSearch";
    private IResourceBundleContext rbCtxt;

    public ButtonFactory(IResourceBundleContext rbc) {
        this.rbCtxt = rbc;
    }

    public JButton createBioExceptionButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.BIOX, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_BIOX));
        result.setIconTextGap(3);
        return result;
    }

    public JButton createTabPreviousButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.PREVIOUS, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_TAB_PREVIOUS));
        result.setIconTextGap(0);
        return result;
    }

    public JButton createTabNextButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.NEXT, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_TAB_NEXT));
        result.setHorizontalTextPosition(2);
        result.setIconTextGap(0);
        return result;
    }

    public JButton createSaveButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.SAVE, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_SAVE));
        result.setIconTextGap(3);
        return result;
    }

    public JButton createConfirmSaveButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.CONFIRM, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_SAVE));
        result.setIconTextGap(3);
        return result;
    }

    public JButton createPreviewButton() {
        JButton result = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.PREVIEW, new Object[0]));
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_PRINT));
        result.setIconTextGap(3);
        return result;
    }

    public JButton createSearchButton(String tooltip) {
        JButton result = new JButton();
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_SEARCH));
        result.setToolTipText(tooltip);
        result.setContentAreaFilled(false);
        return result;
    }

    public JButton createWebSearchButton(String tooltip) {
        JButton result = new JButton();
        result.setIcon(ImageIconCache.getInst().getIcon(BUT_WEB_SEARCH));
        result.setToolTipText(tooltip);
        result.setContentAreaFilled(false);
        return result;
    }

    public JButton createButton(String iconName, String toolTip) {
        JButton result = new JButton();
        result.setIcon(ImageIconCache.getInst().getIcon(iconName));
        result.setToolTipText(toolTip);
        result.setContentAreaFilled(false);
        return result;
    }

    static {
        ImageIconCache.getInst().addIcon(BUT_BIOX, "res/ecmp/images/but-biox.png");
        ImageIconCache.getInst().addIcon(BUT_TAB_PREVIOUS, "res/ecmp/images/but-tab-prev.png");
        ImageIconCache.getInst().addIcon(BUT_TAB_NEXT, "res/ecmp/images/but-tab-next.png");
        ImageIconCache.getInst().addIcon(BUT_SAVE, "res/ecmp/images/but-save.png");
        ImageIconCache.getInst().addIcon(BUT_PRINT, "res/ecmp/images/but-print.png");
        ImageIconCache.getInst().addIcon(BUT_SEARCH, "res/ecmp/images/but-search.png");
        ImageIconCache.getInst().addIcon(BUT_WEB_SEARCH, "res/ecmp/images/but-webSearch.png");
    }
}

