/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class CustomRoundedBorder
implements Border {
    private final Color borderColor;
    private final int radius;
    private final boolean fill;

    public CustomRoundedBorder(Color borderColor, int radius, boolean fill) {
        this.borderColor = borderColor;
        this.radius = radius;
        this.fill = fill;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.radius + 1, this.radius + 1, this.radius + 2, this.radius);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.borderColor);
        if (this.fill) {
            g.fillRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        } else {
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }
    }
}

