/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;

public class MandatoryLabelBuilder {
    private static final String MANDATORY_ICON_PATH = "res/images/star.png";
    private final IResourceBundleContext resBundleCtxt;
    private final ImageIcon mandatoryIcon;

    public MandatoryLabelBuilder(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = MandatoryLabelBuilder.class.getClassLoader();
        }
        this.mandatoryIcon = new ImageIcon(Objects.requireNonNull(cl.getResource(MANDATORY_ICON_PATH)));
    }

    public JLabel create(String text) {
        JLabel result = new JLabel(StringUtils.isBlank((String)text) ? "" : this.resBundleCtxt.getMessage((Object)text, new Object[0]), this.mandatoryIcon, 2);
        result.setHorizontalTextPosition(2);
        return result;
    }

    public LocaleLabel createLocal(String text) {
        LocaleLabel result = new LocaleLabel(this.resBundleCtxt, text);
        result.setIcon(this.mandatoryIcon);
        result.setHorizontalTextPosition(2);
        return result;
    }

    public JLabel createUC(String text) {
        JLabel result = new JLabel(StringUtils.isBlank((String)text) ? "" : this.resBundleCtxt.getMessage((Object)text, new Object[0]), this.mandatoryIcon, 2);
        Font font = result.getFont();
        result.setFont(new Font(font.getName(), 0, 12));
        result.setForeground(new Color(19, 126, 178));
        result.setHorizontalTextPosition(2);
        return result;
    }

    public LocaleLabel createLocalUC(String text) {
        LocaleLabel result = new LocaleLabel(this.resBundleCtxt, text);
        Font font = result.getFont();
        result.setFont(new Font(font.getName(), 0, 15));
        result.setForeground(new Color(19, 126, 178));
        result.setIcon(this.mandatoryIcon);
        result.setHorizontalTextPosition(2);
        return result;
    }

    public LocaleLabel createLocalUCenrolMandatory(String text) {
        LocaleLabel result = new LocaleLabel(this.resBundleCtxt, text);
        Font font = result.getFont();
        result.setFont(new Font(font.getName(), 1, 14));
        result.setText("<html><p>" + result.getText() + "<span style=\"color: #E84C3D\">*</span></p></html>");
        result.setHorizontalTextPosition(2);
        result.setVerticalAlignment(0);
        return result;
    }

    public LocaleLabel createLocalUCenrol(String text) {
        LocaleLabel result = new LocaleLabel(this.resBundleCtxt, text);
        Font font = result.getFont();
        result.setFont(new Font(font.getName(), 1, 14));
        result.setText(result.getText());
        result.setHorizontalTextPosition(2);
        result.setVerticalAlignment(0);
        return result;
    }
}

